/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special;

import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;
import org.screamingsandals.bedwars.special.SpecialItem;

public class LuckyBlock
extends SpecialItem
implements org.screamingsandals.bedwars.api.special.LuckyBlock {
    private List<Map<String, Object>> luckyBlockData;
    private Location placedLocation = null;
    private boolean isPlaced = false;

    public LuckyBlock(Game game, Player player, Team team, List<Map<String, Object>> luckyBlockData) {
        super(game, player, team);
        this.luckyBlockData = luckyBlockData;
        game.registerSpecialItem(this);
    }

    public void place(Location loc) {
        this.placedLocation = loc;
        this.isPlaced = true;
    }

    public void process(Player broker) {
        String type;
        this.game.unregisterSpecialItem(this);
        Random rand = new Random();
        int element = rand.nextInt(this.luckyBlockData.size());
        Map<String, Object> map = this.luckyBlockData.get(element);
        switch (type = (String)map.getOrDefault("type", "nothing")) {
            case "item": {
                Object potentialStack = map.get("stack");
                ItemStack stack = potentialStack instanceof ItemStack ? ((ItemStack)potentialStack).clone() : StackParser.parse(map.get("stack"));
                this.placedLocation.getWorld().dropItem(this.placedLocation, stack);
                break;
            }
            case "potion": {
                PotionEffect potionEffect = StackParser.getPotionEffect(map.get("effect"));
                if (potionEffect == null) break;
                broker.addPotionEffect(potionEffect);
                break;
            }
            case "tnt": {
                new BukkitRunnable(){

                    public void run() {
                        TNTPrimed tnt = (TNTPrimed)LuckyBlock.this.placedLocation.getWorld().spawnEntity(LuckyBlock.this.placedLocation, EntityType.PRIMED_TNT);
                        tnt.setFuseTicks(0);
                    }
                }.runTaskLater((Plugin)Main.getInstance(), 10L);
                break;
            }
            case "teleport": {
                broker.teleport(broker.getLocation().add(0.0, (double)((Integer)map.get("height")).intValue(), 0.0));
            }
        }
        if (map.containsKey("message")) {
            broker.sendMessage((String)map.get("message"));
        }
    }

    @Override
    public boolean isPlaced() {
        return this.isPlaced;
    }

    @Override
    public Location getBlockLocation() {
        return this.placedLocation;
    }
}

