/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.TeamColor;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.special.SpecialItem;
import org.screamingsandals.bedwars.utils.MiscUtils;

public class ProtectionWall
extends SpecialItem
implements org.screamingsandals.bedwars.api.special.ProtectionWall {
    private Game game;
    private Player player;
    private Team team;
    private int breakingTime;
    private int livingTime;
    private int width;
    private int height;
    private int distance;
    private boolean canBreak;
    private ItemStack item;
    private Material buildingMaterial;
    private List<Block> wallBlocks;

    public ProtectionWall(Game game, Player player, Team team, ItemStack item) {
        super(game, player, team);
        this.game = game;
        this.player = player;
        this.team = team;
        this.item = item;
    }

    @Override
    public int getBreakingTime() {
        return this.breakingTime;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDistance() {
        return this.distance;
    }

    @Override
    public boolean canBreak() {
        return this.canBreak;
    }

    @Override
    public Material getMaterial() {
        return this.buildingMaterial;
    }

    @Override
    public void runTask() {
        new BukkitRunnable(){

            public void run() {
                ProtectionWall.this.livingTime++;
                int time = ProtectionWall.this.breakingTime - ProtectionWall.this.livingTime;
                if (!Main.getConfigurator().config.getBoolean("specials.dont-show-success-messages") && time < 6 && time > 0) {
                    MiscUtils.sendActionBarMessage(ProtectionWall.this.player, I18n.i18nonly("specials_protection_wall_destroy").replace("%time%", Integer.toString(time)));
                }
                if (ProtectionWall.this.livingTime == ProtectionWall.this.breakingTime) {
                    for (Block block : ProtectionWall.this.wallBlocks) {
                        block.getChunk().load(false);
                        block.setType(Material.AIR);
                        ProtectionWall.this.game.getRegion().removeBlockBuiltDuringGame(block.getLocation());
                    }
                    ProtectionWall.this.game.unregisterSpecialItem(ProtectionWall.this);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 20L, 20L);
    }

    @Override
    public List<Block> getWallBlocks() {
        return this.wallBlocks;
    }

    private void addBlockToList(Block block) {
        this.wallBlocks.add(block);
        this.game.getRegion().addBuiltDuringGame(block.getLocation());
    }

    public void createWall(boolean bre, int time, int wid, int hei, int dis, Material mat, short legacyData) {
        this.canBreak = bre;
        this.breakingTime = time;
        this.width = wid;
        this.height = hei;
        this.distance = dis;
        this.buildingMaterial = mat;
        this.wallBlocks = new ArrayList<Block>();
        if (this.width % 2 == 0) {
            this.player.sendMessage(I.i18nc("The width of a protection block has to be odd! " + this.width + " is not an odd number.", this.game.getCustomPrefix()));
            ++this.width;
            if (this.width % 2 == 0) {
                return;
            }
        }
        Location wallLocation = this.player.getLocation();
        wallLocation.add(wallLocation.getDirection().setY(0).normalize().multiply(this.distance));
        BlockFace face = MiscUtils.getCardinalDirection(this.player.getLocation());
        int widthStart = (int)Math.floor((double)this.width / 2.0);
        for (int w = widthStart * -1; w < this.width - widthStart; ++w) {
            for (int h = 0; h < this.height; ++h) {
                Block placedBlock;
                Location wallBlock = wallLocation.clone();
                switch (face) {
                    case SOUTH: 
                    case NORTH: 
                    case SELF: {
                        wallBlock.add(0.0, (double)h, (double)w);
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        wallBlock.add((double)w, (double)h, 0.0);
                        break;
                    }
                    case SOUTH_EAST: {
                        wallBlock.add((double)w, (double)h, (double)w);
                        break;
                    }
                    case SOUTH_WEST: {
                        wallBlock.add((double)w, (double)h, (double)(w * -1));
                        break;
                    }
                    case NORTH_EAST: {
                        wallBlock.add((double)(w * -1), (double)h, (double)w);
                        break;
                    }
                    case NORTH_WEST: {
                        wallBlock.add((double)(w * -1), (double)h, (double)(w * -1));
                        break;
                    }
                    default: {
                        wallBlock = null;
                    }
                }
                if (wallBlock == null || !(placedBlock = wallBlock.getBlock()).getType().equals((Object)Material.AIR)) continue;
                ItemStack coloredStack = Main.applyColor(TeamColor.fromApiColor(this.team.getColor()), new ItemStack(this.buildingMaterial, 1, legacyData));
                if (Main.isLegacy()) {
                    placedBlock.setType(coloredStack.getType());
                    try {
                        Block.class.getMethod("setData", Byte.TYPE).invoke((Object)placedBlock, (byte)coloredStack.getDurability());
                    }
                    catch (Exception exception) {}
                } else {
                    placedBlock.setType(coloredStack.getType());
                }
                this.addBlockToList(placedBlock);
            }
        }
        if (this.breakingTime > 0) {
            this.game.registerSpecialItem(this);
            this.runTask();
            if (!Main.getConfigurator().config.getBoolean("specials.dont-show-success-messages")) {
                MiscUtils.sendActionBarMessage(this.player, I18n.i18nonly("specials_protection_wall_created").replace("%time%", Integer.toString(this.breakingTime)));
            }
            if (this.item.getAmount() > 1) {
                this.item.setAmount(this.item.getAmount() - 1);
            } else {
                try {
                    if (this.player.getInventory().getItemInOffHand().equals((Object)this.item)) {
                        this.player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                    } else {
                        this.player.getInventory().remove(this.item);
                    }
                }
                catch (Throwable e) {
                    this.player.getInventory().remove(this.item);
                }
            }
            this.player.updateInventory();
        } else {
            this.game.registerSpecialItem(this);
            if (!Main.getConfigurator().config.getBoolean("specials.dont-show-success-messages")) {
                MiscUtils.sendActionBarMessage(this.player, I18n.i18nonly("specials_protection_wall_created_unbreakable"));
            }
            if (this.item.getAmount() > 1) {
                this.item.setAmount(this.item.getAmount() - 1);
            } else {
                try {
                    if (this.player.getInventory().getItemInOffHand().equals((Object)this.item)) {
                        this.player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                    } else {
                        this.player.getInventory().remove(this.item);
                    }
                }
                catch (Throwable e) {
                    this.player.getInventory().remove(this.item);
                }
            }
            this.player.updateInventory();
        }
    }
}

