/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.TeamColor;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.special.SpecialItem;
import org.screamingsandals.bedwars.utils.MiscUtils;

public class RescuePlatform
extends SpecialItem
implements org.screamingsandals.bedwars.api.special.RescuePlatform {
    private Game game;
    private Player player;
    private Team team;
    private List<Block> platformBlocks;
    private Material buildingMaterial;
    private ItemStack item;
    private boolean canBreak;
    private int breakingTime;
    private int livingTime;

    public RescuePlatform(Game game, Player player, Team team, ItemStack item) {
        super(game, player, team);
        this.game = game;
        this.player = player;
        this.team = team;
        this.item = item;
    }

    @Override
    public int getBreakingTime() {
        return this.breakingTime;
    }

    @Override
    public boolean canBreak() {
        return this.canBreak;
    }

    @Override
    public Material getMaterial() {
        return this.buildingMaterial;
    }

    @Override
    public ItemStack getStack() {
        return this.item;
    }

    @Override
    public void runTask() {
        new BukkitRunnable(){

            public void run() {
                RescuePlatform.this.livingTime++;
                int time = RescuePlatform.this.breakingTime - RescuePlatform.this.livingTime;
                if (!Main.getConfigurator().config.getBoolean("specials.dont-show-success-messages") && time < 6 && time > 0) {
                    MiscUtils.sendActionBarMessage(RescuePlatform.this.player, I18n.i18nonly("specials_rescue_platform_destroy").replace("%time%", Integer.toString(time)));
                }
                if (RescuePlatform.this.livingTime == RescuePlatform.this.breakingTime) {
                    for (Block block : RescuePlatform.this.platformBlocks) {
                        block.getChunk().load(false);
                        block.setType(Material.AIR);
                        RescuePlatform.this.removeBlockFromList(block);
                        RescuePlatform.this.game.getRegion().removeBlockBuiltDuringGame(block.getLocation());
                    }
                    RescuePlatform.this.game.unregisterSpecialItem(RescuePlatform.this);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 20L, 20L);
    }

    @Override
    public List<Block> getPlatformBlocks() {
        return this.platformBlocks;
    }

    private void addBlockToList(Block block) {
        this.platformBlocks.add(block);
        this.game.getRegion().addBuiltDuringGame(block.getLocation());
    }

    private void removeBlockFromList(Block block) {
        this.game.getRegion().removeBlockBuiltDuringGame(block.getLocation());
    }

    public void createPlatform(boolean bre, int time, int dist, Material bMat, short legacyData) {
        this.canBreak = bre;
        this.breakingTime = time;
        this.buildingMaterial = bMat;
        this.platformBlocks = new ArrayList<Block>();
        Location center = this.player.getLocation().clone();
        center.setY(center.getY() - (double)dist);
        for (BlockFace blockFace : BlockFace.values()) {
            Block placedBlock;
            if (blockFace.equals((Object)BlockFace.DOWN) || blockFace.equals((Object)BlockFace.UP) || (placedBlock = center.getBlock().getRelative(blockFace)).getType() != Material.AIR) continue;
            ItemStack coloredStack = Main.applyColor(TeamColor.fromApiColor(this.team.getColor()), new ItemStack(this.buildingMaterial, 1, legacyData));
            if (Main.isLegacy()) {
                placedBlock.setType(coloredStack.getType());
                try {
                    Block.class.getMethod("setData", Byte.TYPE).invoke((Object)placedBlock, (byte)coloredStack.getDurability());
                }
                catch (Exception exception) {}
            } else {
                placedBlock.setType(coloredStack.getType());
            }
            this.addBlockToList(placedBlock);
        }
        if (this.breakingTime > 0) {
            this.game.registerSpecialItem(this);
            this.runTask();
            if (!Main.getConfigurator().config.getBoolean("specials.dont-show-success-messages")) {
                MiscUtils.sendActionBarMessage(this.player, I18n.i18nonly("specials_rescue_platform_created").replace("%time%", Integer.toString(this.breakingTime)));
            }
            if (this.item.getAmount() > 1) {
                this.item.setAmount(this.item.getAmount() - 1);
            } else {
                try {
                    if (this.player.getInventory().getItemInOffHand().equals((Object)this.item)) {
                        this.player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                    } else {
                        this.player.getInventory().remove(this.item);
                    }
                }
                catch (Throwable e) {
                    this.player.getInventory().remove(this.item);
                }
            }
            this.player.updateInventory();
        } else {
            this.game.registerSpecialItem(this);
            if (!Main.getConfigurator().config.getBoolean("specials.dont-show-success-messages")) {
                MiscUtils.sendActionBarMessage(this.player, I18n.i18nonly("specials_rescue_platform_created_unbreakable"));
            }
            if (this.item.getAmount() > 1) {
                this.item.setAmount(this.item.getAmount() - 1);
            } else {
                try {
                    if (this.player.getInventory().getItemInOffHand().equals((Object)this.item)) {
                        this.player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                    } else {
                        this.player.getInventory().remove(this.item);
                    }
                }
                catch (Throwable e) {
                    this.player.getInventory().remove(this.item);
                }
            }
            this.player.updateInventory();
        }
    }
}

