/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special;

import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.TeamColor;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.nms.entity.EntityUtils;
import org.screamingsandals.bedwars.special.SpecialItem;
import org.screamingsandals.bedwars.utils.MiscUtils;

public class TNTSheep
extends SpecialItem
implements org.screamingsandals.bedwars.api.special.TNTSheep {
    private LivingEntity entity;
    private TNTPrimed tnt;
    private Location loc;
    private ItemStack item;
    private double speed;
    private double followRange;
    private double maxTargetDistance;
    private int explosionTime;

    public TNTSheep(Game game, Player player, Team team, Location loc, ItemStack item, double speed, double followRange, double maxTargetDistance, int explosionTime) {
        super(game, player, team);
        this.loc = loc;
        this.item = item;
        this.speed = speed;
        this.followRange = followRange;
        this.maxTargetDistance = maxTargetDistance;
        this.explosionTime = explosionTime * 20;
    }

    @Override
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Override
    public Location getInitialLocation() {
        return this.loc;
    }

    @Override
    public TNTPrimed getTNT() {
        return this.tnt;
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }

    @Override
    public double getFollowRange() {
        return this.followRange;
    }

    public void spawn() {
        final Sheep sheep = (Sheep)this.loc.getWorld().spawnEntity(this.loc, EntityType.SHEEP);
        TeamColor color = TeamColor.fromApiColor(this.team.getColor());
        Player target = MiscUtils.findTarget(this.game, this.player, this.maxTargetDistance);
        sheep.setColor(DyeColor.getByWoolData((byte)((byte)color.woolData)));
        if (target == null) {
            this.player.sendMessage(I.i18nc("specials_tntsheep_no_target_found", this.game.getCustomPrefix()));
            sheep.remove();
            return;
        }
        this.entity = sheep;
        EntityUtils.makeMobAttackTarget((LivingEntity)sheep, this.speed, this.followRange, 0.0).getTargetSelector();
        sheep.setTarget((LivingEntity)target);
        this.tnt = (TNTPrimed)this.loc.getWorld().spawnEntity(this.loc, EntityType.PRIMED_TNT);
        this.tnt.setFuseTicks(this.explosionTime);
        this.tnt.setIsIncendiary(false);
        try {
            sheep.addPassenger((Entity)this.tnt);
        }
        catch (Throwable t) {
            sheep.setPassenger((Entity)this.tnt);
        }
        this.game.registerSpecialItem(this);
        Main.registerGameEntity((Entity)sheep, (org.screamingsandals.bedwars.game.Game)this.game);
        Main.registerGameEntity((Entity)this.tnt, (org.screamingsandals.bedwars.game.Game)this.game);
        if (this.item.getAmount() > 1) {
            this.item.setAmount(this.item.getAmount() - 1);
        } else {
            try {
                if (this.player.getInventory().getItemInOffHand().equals((Object)this.item)) {
                    this.player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                } else {
                    this.player.getInventory().remove(this.item);
                }
            }
            catch (Throwable e) {
                this.player.getInventory().remove(this.item);
            }
        }
        this.player.updateInventory();
        new BukkitRunnable(){

            public void run() {
                TNTSheep.this.tnt.remove();
                sheep.remove();
                TNTSheep.this.game.unregisterSpecialItem(TNTSheep.this);
            }
        }.runTaskLater((Plugin)Main.getInstance(), (long)(this.explosionTime + 13));
    }
}

