/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special;

import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;
import org.screamingsandals.bedwars.special.SpecialItem;
import org.screamingsandals.bedwars.utils.MiscUtils;
import org.screamingsandals.bedwars.utils.Sounds;

public class Trap
extends SpecialItem
implements org.screamingsandals.bedwars.api.special.Trap {
    private List<Map<String, Object>> trapData;
    private Location location;
    private RunningTeam runningTeam;

    public Trap(Game game, Player player, RunningTeam team, List<Map<String, Object>> trapData) {
        super(game, player, team);
        this.trapData = trapData;
        this.runningTeam = team;
        game.registerSpecialItem(this);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean isPlaced() {
        return this.location != null;
    }

    public void place(Location loc) {
        this.location = loc;
    }

    public void process(Player player, RunningTeam runningTeam, boolean forceDestroy) {
        if (runningTeam == this.runningTeam || forceDestroy) {
            this.game.unregisterSpecialItem(this);
            this.location.getBlock().setType(Material.AIR);
            return;
        }
        for (Map<String, Object> data : this.trapData) {
            PotionEffect effect;
            if (data.containsKey("sound")) {
                String sound = (String)data.get("sound");
                Sounds.playSound(player, this.location, sound, null, 1.0f, 1.0f);
            }
            if (data.containsKey("effect") && (effect = StackParser.getPotionEffect(data.get("effect"))) != null) {
                player.addPotionEffect(effect);
            }
            if (!data.containsKey("damage")) continue;
            double damage = (Double)data.get("damage");
            player.damage(damage);
        }
        for (Player p : this.runningTeam.getConnectedPlayers()) {
            MiscUtils.sendActionBarMessage(p, I18n.i18nonly("specials_trap_caught_team").replace("%player%", player.getDisplayName()));
        }
        MiscUtils.sendActionBarMessage(player, I18n.i18nonly("specials_trap_caught").replace("%team%", this.getTeam().getName()));
    }
}

