/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.nms.entity.PlayerUtils;
import org.screamingsandals.bedwars.special.SpecialItem;
import org.screamingsandals.bedwars.utils.SpawnEffects;

public class WarpPowder
extends SpecialItem
implements org.screamingsandals.bedwars.api.special.WarpPowder {
    private BukkitTask teleportingTask = null;
    private int teleportingTime;
    private ItemStack item;

    public WarpPowder(Game game, Player player, Team team, ItemStack item, int teleportingTime) {
        super(game, player, team);
        this.item = item;
        this.teleportingTime = teleportingTime;
    }

    @Override
    public ItemStack getStack() {
        return this.item;
    }

    @Override
    public void cancelTeleport(boolean showCancelledMessage) {
        try {
            this.teleportingTask.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.game.unregisterSpecialItem(this);
        if (showCancelledMessage) {
            this.player.sendMessage(I.i18nc("specials_warp_powder_canceled", this.game.getCustomPrefix()));
        }
    }

    @Override
    public void runTask() {
        this.game.registerSpecialItem(this);
        this.player.sendMessage(I.i18nc("specials_warp_powder_started", this.game.getCustomPrefix()).replace("%time%", Double.toString(this.teleportingTime)));
        this.teleportingTask = new BukkitRunnable(){

            public void run() {
                if (WarpPowder.this.teleportingTime == 0) {
                    WarpPowder.this.cancelTeleport(false);
                    if (WarpPowder.this.item.getAmount() > 1) {
                        WarpPowder.this.item.setAmount(WarpPowder.this.item.getAmount() - 1);
                    } else {
                        try {
                            if (WarpPowder.this.player.getInventory().getItemInOffHand().equals((Object)WarpPowder.this.item)) {
                                WarpPowder.this.player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                            } else {
                                WarpPowder.this.player.getInventory().remove(WarpPowder.this.item);
                            }
                        }
                        catch (Throwable e) {
                            WarpPowder.this.player.getInventory().remove(WarpPowder.this.item);
                        }
                    }
                    WarpPowder.this.player.updateInventory();
                    PlayerUtils.teleportPlayer(WarpPowder.this.player, WarpPowder.this.team.getTeamSpawn());
                } else {
                    SpawnEffects.spawnEffect(WarpPowder.this.game, WarpPowder.this.player, "game-effects.warppowdertick");
                    WarpPowder.this.teleportingTime--;
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 20L);
    }
}

