/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special.listener;

import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.APIUtils;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToBoughtItem;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.special.ArrowBlocker;
import org.screamingsandals.bedwars.utils.DelayFactory;
import org.screamingsandals.bedwars.utils.MiscUtils;

public class ArrowBlockerListener
implements Listener {
    private static final String ARROW_BLOCKER_PREFIX = "Module:ArrowBlocker:";

    @EventHandler
    public void onArrowBlockerRegistered(BedwarsApplyPropertyToBoughtItem event) {
        if (event.getPropertyName().equalsIgnoreCase("arrowblocker")) {
            ItemStack stack = event.getStack();
            APIUtils.hashIntoInvisibleString(stack, this.applyProperty(event));
        }
    }

    @EventHandler
    public void onPlayerUseItem(PlayerInteractEvent event) {
        ItemStack stack;
        String unhidden;
        Player player = event.getPlayer();
        if (!Main.isPlayerInGame(player)) {
            return;
        }
        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
        Game game = gPlayer.getGame();
        if (!(event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK || game.getStatus() != GameStatus.RUNNING || gPlayer.isSpectator || event.getItem() == null || (unhidden = APIUtils.unhashFromInvisibleStringStartsWith(stack = event.getItem(), ARROW_BLOCKER_PREFIX)) == null)) {
            if (!game.isDelayActive(player, ArrowBlocker.class)) {
                event.setCancelled(true);
                int protectionTime = Integer.parseInt(unhidden.split(":")[2]);
                int delay = Integer.parseInt(unhidden.split(":")[3]);
                ArrowBlocker arrowBlocker = new ArrowBlocker(game, event.getPlayer(), game.getTeamOfPlayer(event.getPlayer()), stack, protectionTime);
                if (arrowBlocker.isActivated()) {
                    event.getPlayer().sendMessage(I.i18nc("specials_arrow_blocker_already_activated", game.getCustomPrefix()));
                    return;
                }
                if (delay > 0) {
                    DelayFactory delayFactory = new DelayFactory(delay, arrowBlocker, player, game);
                    game.registerDelay(delayFactory);
                }
                arrowBlocker.activate();
            } else {
                event.setCancelled(true);
                int delay = game.getActiveDelay(player, ArrowBlocker.class).getRemainDelay();
                MiscUtils.sendActionBarMessage(player, I18n.i18nonly("special_item_delay").replace("%time%", String.valueOf(delay)));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = ((Player)entity).getPlayer();
        if (!Main.isPlayerInGame(player)) {
            return;
        }
        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
        Game game = gPlayer.getGame();
        if (gPlayer.isSpectator) {
            return;
        }
        ArrowBlocker arrowBlocker = (ArrowBlocker)game.getFirstActivedSpecialItemOfPlayer(player, ArrowBlocker.class);
        if (arrowBlocker != null && event.getCause() == EntityDamageEvent.DamageCause.PROJECTILE) {
            event.setCancelled(true);
        }
    }

    private String applyProperty(BedwarsApplyPropertyToBoughtItem event) {
        return ARROW_BLOCKER_PREFIX + MiscUtils.getIntFromProperty("protection-time", "specials.arrow-blocker.protection-time", event) + ":" + MiscUtils.getIntFromProperty("delay", "specials.arrow-blocker.delay", event);
    }
}

