/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special.listener;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.APIUtils;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToBoughtItem;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.api.special.SpecialItem;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.special.Golem;
import org.screamingsandals.bedwars.utils.DelayFactory;
import org.screamingsandals.bedwars.utils.MiscUtils;

public class GolemListener
implements Listener {
    private static final String GOLEM_PREFIX = "Module:Golem:";

    @EventHandler
    public void onGolemRegister(BedwarsApplyPropertyToBoughtItem event) {
        if (event.getPropertyName().equalsIgnoreCase("golem")) {
            ItemStack stack = event.getStack();
            APIUtils.hashIntoInvisibleString(stack, this.applyProperty(event));
        }
    }

    @EventHandler
    public void onGolemUse(PlayerInteractEvent event) {
        ItemStack stack;
        String unhidden;
        Player player = event.getPlayer();
        if (!Main.isPlayerInGame(player)) {
            return;
        }
        GamePlayer gamePlayer = Main.getPlayerGameProfile(player);
        Game game = gamePlayer.getGame();
        if (!(event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK || game.getStatus() != GameStatus.RUNNING || gamePlayer.isSpectator || event.getItem() == null || (unhidden = APIUtils.unhashFromInvisibleStringStartsWith(stack = event.getItem(), GOLEM_PREFIX)) == null)) {
            if (!game.isDelayActive(player, Golem.class)) {
                event.setCancelled(true);
                double speed = Double.parseDouble(unhidden.split(":")[2]);
                double follow = Double.parseDouble(unhidden.split(":")[3]);
                double health = Double.parseDouble(unhidden.split(":")[4]);
                boolean showName = Boolean.parseBoolean(unhidden.split(":")[5]);
                int delay = Integer.parseInt(unhidden.split(":")[6]);
                String name = unhidden.split(":")[8];
                Location location = event.getClickedBlock() == null ? player.getLocation() : event.getClickedBlock().getRelative(event.getBlockFace()).getLocation().add(0.5, 0.5, 0.5);
                Golem golem = new Golem(game, player, game.getTeamOfPlayer(player), stack, location, speed, follow, health, name, showName);
                if (delay > 0) {
                    DelayFactory delayFactory = new DelayFactory(delay, golem, player, game);
                    game.registerDelay(delayFactory);
                }
                golem.spawn();
            } else {
                event.setCancelled(true);
                int delay = game.getActiveDelay(player, Golem.class).getRemainDelay();
                MiscUtils.sendActionBarMessage(player, I18n.i18nonly("special_item_delay").replace("%time%", String.valueOf(delay)));
            }
        }
    }

    @EventHandler
    public void onGolemDamage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof IronGolem)) {
            return;
        }
        IronGolem ironGolem = (IronGolem)event.getEntity();
        for (String name : Main.getGameNames()) {
            Game game = Main.getGame(name);
            if (game.getStatus() != GameStatus.RUNNING || !ironGolem.getWorld().equals(game.getGameWorld())) continue;
            List<SpecialItem> golems = game.getActivedSpecialItems(Golem.class);
            for (SpecialItem item : golems) {
                if (!(item instanceof Golem)) continue;
                Golem golem = (Golem)item;
                if (golem.getEntity().equals(ironGolem)) {
                    Player player;
                    ProjectileSource shooter;
                    Player player2;
                    if (event.getDamager() instanceof Player ? Main.isPlayerInGame(player2 = (Player)event.getDamager()) && golem.getTeam() != game.getTeamOfPlayer(player2) : event.getDamager() instanceof Projectile && (shooter = ((Projectile)event.getDamager()).getShooter()) instanceof Player && Main.isPlayerInGame(player = (Player)shooter) && golem.getTeam() != game.getTeamOfPlayer(player)) {
                        return;
                    }
                    event.setCancelled(game.getOriginalOrInheritedFriendlyfire());
                    return;
                }
                return;
            }
        }
    }

    @EventHandler
    public void onGolemTarget(EntityTargetEvent event) {
        if (!(event.getEntity() instanceof IronGolem)) {
            return;
        }
        IronGolem ironGolem = (IronGolem)event.getEntity();
        for (String name : Main.getGameNames()) {
            Game game = Main.getGame(name);
            if (game.getStatus() != GameStatus.RUNNING && game.getStatus() != GameStatus.GAME_END_CELEBRATING || !ironGolem.getWorld().equals(game.getGameWorld())) continue;
            List<SpecialItem> golems = game.getActivedSpecialItems(Golem.class);
            for (SpecialItem item : golems) {
                Golem golem;
                if (!(item instanceof Golem) || !(golem = (Golem)item).getEntity().equals(ironGolem)) continue;
                if (event.getTarget() instanceof Player) {
                    Player player = (Player)event.getTarget();
                    if (game.isProtectionActive(player)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (!Main.isPlayerInGame(player) || golem.getTeam() != game.getTeamOfPlayer(player)) continue;
                    event.setCancelled(true);
                    Player playerTarget = MiscUtils.findTarget(game, player, golem.getFollowRange());
                    if (playerTarget == null) continue;
                    ironGolem.setTarget((LivingEntity)playerTarget);
                    return;
                }
                if (!(event.getTarget() instanceof IronGolem)) continue;
                for (SpecialItem item2 : golems) {
                    Golem golem2;
                    if (!(item2 instanceof Golem) || !(golem2 = (Golem)item2).getEntity().equals(event.getTarget()) || golem2.getTeam() != golem.getTeam()) continue;
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onGolemTargetDie(PlayerDeathEvent event) {
        if (Main.isPlayerInGame(event.getEntity())) {
            Game game = Main.getPlayerGameProfile(event.getEntity()).getGame();
            List<SpecialItem> golems = game.getActivedSpecialItems(Golem.class);
            for (SpecialItem item : golems) {
                Golem golem = (Golem)item;
                IronGolem iron = (IronGolem)golem.getEntity();
                if (iron.getTarget() == null || !iron.getTarget().equals(event.getEntity())) continue;
                iron.setTarget(null);
            }
        }
    }

    @EventHandler
    public void onGolemDeath(EntityDeathEvent event) {
        if (!(event.getEntity() instanceof IronGolem)) {
            return;
        }
        IronGolem ironGolem = (IronGolem)event.getEntity();
        for (String name : Main.getGameNames()) {
            Game game = Main.getGame(name);
            if (game.getStatus() != GameStatus.RUNNING && game.getStatus() != GameStatus.GAME_END_CELEBRATING || !ironGolem.getWorld().equals(game.getGameWorld())) continue;
            List<SpecialItem> golems = game.getActivedSpecialItems(Golem.class);
            for (SpecialItem item : golems) {
                Golem golem;
                if (!(item instanceof Golem) || !(golem = (Golem)item).getEntity().equals(ironGolem)) continue;
                event.getDrops().clear();
            }
        }
    }

    private String applyProperty(BedwarsApplyPropertyToBoughtItem event) {
        return GOLEM_PREFIX + MiscUtils.getDoubleFromProperty("speed", "specials.golem.speed", event) + ":" + MiscUtils.getDoubleFromProperty("follow-range", "specials.golem.follow-range", event) + ":" + MiscUtils.getDoubleFromProperty("health", "specials.golem.health", event) + ":" + MiscUtils.getBooleanFromProperty("show-name", "specials.golem.show-name", event) + ":" + MiscUtils.getIntFromProperty("delay", "specials.golem.delay", event) + ":" + MiscUtils.getBooleanFromProperty("collidable", "specials.golem.collidable", event) + ":" + MiscUtils.getStringFromProperty("name-format", "specials.golem.name-format", event);
    }
}

