/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special.listener;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.APIUtils;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToBoughtItem;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.api.special.SpecialItem;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.special.TNTSheep;
import org.screamingsandals.bedwars.utils.MiscUtils;

public class TNTSheepListener
implements Listener {
    private static final String TNT_SHEEP_PREFIX = "Module:TNTSheep:";

    @EventHandler
    public void onTNTSheepRegistered(BedwarsApplyPropertyToBoughtItem event) {
        if (event.getPropertyName().equalsIgnoreCase("tntsheep")) {
            ItemStack stack = event.getStack();
            APIUtils.hashIntoInvisibleString(stack, this.applyProperty(event));
        }
    }

    @EventHandler
    public void onTNTSheepUsed(PlayerInteractEvent event) {
        ItemStack stack;
        String unhidden;
        Player player = event.getPlayer();
        if (!Main.isPlayerInGame(player)) {
            return;
        }
        GamePlayer gamePlayer = Main.getPlayerGameProfile(player);
        Game game = gamePlayer.getGame();
        if (!(event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK || game.getStatus() != GameStatus.RUNNING || gamePlayer.isSpectator || event.getItem() == null || (unhidden = APIUtils.unhashFromInvisibleStringStartsWith(stack = event.getItem(), TNT_SHEEP_PREFIX)) == null)) {
            event.setCancelled(true);
            double speed = Double.parseDouble(unhidden.split(":")[2]);
            double follow = Double.parseDouble(unhidden.split(":")[3]);
            double maxTargetDistance = Double.parseDouble(unhidden.split(":")[4]);
            int explosionTime = Integer.parseInt(unhidden.split(":")[5]);
            Location startLocation = event.getClickedBlock() == null ? player.getLocation() : event.getClickedBlock().getRelative(event.getBlockFace()).getLocation();
            TNTSheep sheep = new TNTSheep(game, player, game.getTeamOfPlayer(player), startLocation, stack, speed, follow, maxTargetDistance, explosionTime);
            sheep.spawn();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTNTSheepDamage(EntityDamageByEntityEvent event) {
        block8: {
            block7: {
                if (event.isCancelled() || event.getCause().equals((Object)EntityDamageEvent.DamageCause.CUSTOM) || event.getCause().equals((Object)EntityDamageEvent.DamageCause.VOID) || event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL)) {
                    return;
                }
                if (!(event.getEntity() instanceof Player)) break block7;
                Player player = (Player)event.getEntity();
                if (!Main.isPlayerInGame(player)) break block8;
                GamePlayer gamePlayer = Main.getPlayerGameProfile(player);
                Game game = gamePlayer.getGame();
                if (event.getDamager() instanceof TNTPrimed && !game.getOriginalOrInheritedFriendlyfire()) {
                    TNTPrimed tnt = (TNTPrimed)event.getDamager();
                    List<SpecialItem> sheeps = game.getActivedSpecialItems(TNTSheep.class);
                    for (SpecialItem item : sheeps) {
                        TNTSheep sheep;
                        if (!(item instanceof TNTSheep) || !tnt.equals((sheep = (TNTSheep)item).getTNT())) continue;
                        if (sheep.getTeam() == game.getTeamOfPlayer(player)) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                }
                break block8;
            }
            if (event.getEntity() instanceof Creature) {
                Creature mob = (Creature)event.getEntity();
                for (String name : Main.getGameNames()) {
                    Game game = Main.getGame(name);
                    if (game.getStatus() != GameStatus.RUNNING || !mob.getWorld().equals(game.getGameWorld())) continue;
                    List<SpecialItem> sheeps = game.getActivedSpecialItems(TNTSheep.class);
                    for (SpecialItem item : sheeps) {
                        TNTSheep sheep;
                        if (!(item instanceof TNTSheep) || !mob.equals((sheep = (TNTSheep)item).getEntity())) continue;
                        event.setDamage(0.0);
                        return;
                    }
                }
            }
        }
    }

    @EventHandler
    public void onTNTSheepInteractOtherUser(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (Main.isPlayerInGame(player)) {
            GamePlayer gamePlayer = Main.getPlayerGameProfile(player);
            Game game = gamePlayer.getGame();
            Entity rightClicked = event.getRightClicked();
            Entity vehicle = rightClicked.getVehicle();
            List<SpecialItem> sheeps = game.getActivedSpecialItems(TNTSheep.class);
            for (SpecialItem item : sheeps) {
                TNTSheep sheep;
                if (!(item instanceof TNTSheep) || !(sheep = (TNTSheep)item).getEntity().equals(rightClicked) && !sheep.getEntity().equals(vehicle)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    private String applyProperty(BedwarsApplyPropertyToBoughtItem event) {
        return TNT_SHEEP_PREFIX + MiscUtils.getDoubleFromProperty("speed", "specials.tnt-sheep.speed", event) + ":" + MiscUtils.getDoubleFromProperty("follow-range", "specials.tnt-sheep.follow-range", event) + ":" + MiscUtils.getDoubleFromProperty("max-target-distance", "specials.tnt-sheep.max-target-distance", event) + ":" + MiscUtils.getIntFromProperty("explosion-time", "specials.tnt-sheep.explosion-time", event);
    }
}

