/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special.listener;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.APIUtils;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToBoughtItem;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerBreakBlock;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerBuildBlock;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.api.special.SpecialItem;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.special.Trap;

public class TrapListener
implements Listener {
    private static final String TRAP_PREFIX = "Module:Trap:";

    @EventHandler
    public void onTrapRegistered(BedwarsApplyPropertyToBoughtItem event) {
        if (event.getPropertyName().equalsIgnoreCase("trap")) {
            ItemStack stack = event.getStack();
            Trap trap = new Trap(event.getGame(), event.getPlayer(), event.getGame().getTeamOfPlayer(event.getPlayer()), (List)event.getProperty("data"));
            int id = System.identityHashCode(trap);
            String trapString = TRAP_PREFIX + id;
            APIUtils.hashIntoInvisibleString(stack, trapString);
        }
    }

    @EventHandler
    public void onTrapBuild(BedwarsPlayerBuildBlock event) {
        if (event.isCancelled()) {
            return;
        }
        ItemStack trapItem = event.getItemInHand();
        String unhidden = APIUtils.unhashFromInvisibleStringStartsWith(trapItem, TRAP_PREFIX);
        if (unhidden != null) {
            int classID = Integer.parseInt(unhidden.split(":")[2]);
            for (SpecialItem special : event.getGame().getActivedSpecialItems(Trap.class)) {
                Trap trap = (Trap)special;
                if (System.identityHashCode(trap) != classID) continue;
                trap.place(event.getBlock().getLocation());
                event.getPlayer().sendMessage(I.i18nc("trap_built", event.getGame().getCustomPrefix()));
                return;
            }
        }
    }

    @EventHandler
    public void onTrapBreak(BedwarsPlayerBreakBlock event) {
        Player player = event.getPlayer();
        if (!Main.isPlayerInGame(player)) {
            return;
        }
        for (SpecialItem special : event.getGame().getActivedSpecialItems(Trap.class)) {
            Trap trapBlock = (Trap)special;
            RunningTeam runningTeam = event.getTeam();
            if (!trapBlock.isPlaced() || !event.getBlock().getLocation().equals((Object)trapBlock.getLocation())) continue;
            event.setDrops(false);
            trapBlock.process(event.getPlayer(), runningTeam, true);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (event.isCancelled() || !Main.isPlayerInGame(player)) {
            return;
        }
        double difX = Math.abs(event.getFrom().getX() - event.getTo().getX());
        double difZ = Math.abs(event.getFrom().getZ() - event.getTo().getZ());
        if (difX == 0.0 && difZ == 0.0) {
            return;
        }
        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
        Game game = gPlayer.getGame();
        if (game.getStatus() == GameStatus.RUNNING && !gPlayer.isSpectator) {
            for (SpecialItem special : game.getActivedSpecialItems(Trap.class)) {
                Trap trapBlock = (Trap)special;
                if (!trapBlock.isPlaced() || game.getTeamOfPlayer(player) == trapBlock.getTeam() || !event.getTo().getBlock().getLocation().equals((Object)trapBlock.getLocation())) continue;
                trapBlock.process(player, game.getPlayerTeam(gPlayer), false);
            }
        }
    }
}

