/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.statistics;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;

public class PlayerStatistic
implements ConfigurationSerializable,
org.screamingsandals.bedwars.api.statistics.PlayerStatistic {
    private UUID uuid;
    private String name = "";
    private int deaths;
    private int destroyedBeds;
    private int kills;
    private int loses;
    private int score;
    private int wins;

    public PlayerStatistic(UUID uuid) {
        this.uuid = uuid;
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && !this.name.equals(player.getName())) {
            this.name = player.getName();
        }
    }

    public PlayerStatistic(Map<String, Object> deserialize) {
        if (deserialize.containsKey("deaths")) {
            this.deaths = (Integer)deserialize.get("deaths");
        }
        if (deserialize.containsKey("destroyedBeds")) {
            this.destroyedBeds = (Integer)deserialize.get("destroyedBeds");
        }
        if (deserialize.containsKey("kills")) {
            this.kills = (Integer)deserialize.get("kills");
        }
        if (deserialize.containsKey("loses")) {
            this.loses = (Integer)deserialize.get("loses");
        }
        if (deserialize.containsKey("score")) {
            this.score = (Integer)deserialize.get("score");
        }
        if (deserialize.containsKey("wins")) {
            this.wins = (Integer)deserialize.get("wins");
        }
        if (deserialize.containsKey("name")) {
            this.name = (String)deserialize.get("name");
        }
        if (deserialize.containsKey("uuid")) {
            this.uuid = UUID.fromString((String)deserialize.get("uuid"));
        }
    }

    @Override
    public int getGames() {
        return this.getWins() + this.getLoses();
    }

    @Override
    public void addDeaths(int deaths) {
        this.deaths += deaths;
    }

    @Override
    public void addDestroyedBeds(int destroyedBeds) {
        this.destroyedBeds += destroyedBeds;
    }

    @Override
    public void addKills(int kills) {
        this.kills += kills;
    }

    @Override
    public void addLoses(int loses) {
        this.loses += loses;
    }

    @Override
    public void addScore(int score) {
        this.score += score;
        Main.getPlayerStatisticsManager().updateScore(this);
    }

    @Override
    public void addWins(int wins) {
        this.wins += wins;
    }

    public UUID getId() {
        return this.uuid;
    }

    public void setId(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public double getKD() {
        double kd = 0.0;
        if (this.deaths == 0) {
            kd = this.kills;
        } else if (this.kills != 0) {
            kd = (double)this.kills / (double)this.deaths;
        }
        kd = (double)Math.round(kd * 100.0) / 100.0;
        return kd;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> playerStatistic = new HashMap<String, Object>();
        playerStatistic.put("deaths", this.deaths);
        playerStatistic.put("destroyedBeds", this.destroyedBeds);
        playerStatistic.put("kills", this.kills);
        playerStatistic.put("loses", this.loses);
        playerStatistic.put("score", this.score);
        playerStatistic.put("wins", this.wins);
        playerStatistic.put("name", this.name);
        return playerStatistic;
    }

    @Override
    public int getDeaths() {
        return this.deaths;
    }

    @Override
    public int getDestroyedBeds() {
        return this.destroyedBeds;
    }

    @Override
    public int getKills() {
        return this.kills;
    }

    @Override
    public int getLoses() {
        return this.loses;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getWins() {
        return this.wins;
    }

    public void setName(String name) {
        this.name = name;
    }
}

