/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.statistics;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsSavePlayerStatisticEvent;
import org.screamingsandals.bedwars.api.statistics.PlayerStatisticsManager;
import org.screamingsandals.bedwars.statistics.LeaderboardEntry;
import org.screamingsandals.bedwars.statistics.PlayerStatistic;

public class PlayerStatisticManager
implements PlayerStatisticsManager {
    private File databaseFile = null;
    private FileConfiguration fileDatabase = null;
    private Map<UUID, PlayerStatistic> playerStatistic;
    private Map<UUID, Map.Entry<String, Integer>> allScores = new HashMap<UUID, Map.Entry<String, Integer>>();

    public PlayerStatisticManager() {
        this.playerStatistic = new HashMap<UUID, PlayerStatistic>();
    }

    public PlayerStatistic getStatistic(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        return this.getStatistic(player.getUniqueId());
    }

    @Override
    public PlayerStatistic getStatistic(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        if (!this.playerStatistic.containsKey(uuid)) {
            return this.loadStatistic(uuid);
        }
        return this.playerStatistic.get(uuid);
    }

    public void initialize() {
        if (!Main.getConfigurator().config.getBoolean("statistics.enabled", false)) {
            return;
        }
        if (Main.getConfigurator().config.getString("statistics.type").equalsIgnoreCase("database")) {
            this.initializeDatabase();
        } else {
            File file = new File(Main.getInstance().getDataFolder() + "/database/bw_stats_players.yml");
            this.loadYml(file);
        }
        this.initializeLeaderboard();
    }

    public void initializeDatabase() {
        Main.getInstance().getLogger().info("Loading statistics from database ...");
        try {
            Main.getDatabaseManager().initialize();
            try (Connection connection = Main.getDatabaseManager().getConnection();){
                connection.setAutoCommit(false);
                PreparedStatement preparedStatement = connection.prepareStatement(Main.getDatabaseManager().getCreateTableSql());
                preparedStatement.executeUpdate();
                connection.commit();
                preparedStatement.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeLeaderboard() {
        this.allScores.clear();
        if (Main.getConfigurator().config.getString("statistics.type").equalsIgnoreCase("database")) {
            try (Connection connection = Main.getDatabaseManager().getConnection();){
                connection.setAutoCommit(false);
                PreparedStatement preparedStatement = connection.prepareStatement(Main.getDatabaseManager().getScoresSql(), 1004, 1007);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.first()) {
                    do {
                        this.allScores.put(UUID.fromString(resultSet.getString("uuid")), new AbstractMap.SimpleEntry<String, Integer>(resultSet.getString("name"), resultSet.getInt("score")));
                    } while (resultSet.next());
                }
                connection.commit();
                preparedStatement.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            if (!this.fileDatabase.isSet("data") || !this.fileDatabase.isConfigurationSection("data")) {
                return;
            }
            for (String key : this.fileDatabase.getConfigurationSection("data").getKeys(false)) {
                this.allScores.put(UUID.fromString(key), new AbstractMap.SimpleEntry<String, Integer>(this.fileDatabase.getString("data." + key + ".name"), this.fileDatabase.getInt("data." + key + ".score")));
            }
        }
    }

    @Override
    public List<org.screamingsandals.bedwars.api.statistics.LeaderboardEntry> getLeaderboard(int count) {
        ArrayList<org.screamingsandals.bedwars.api.statistics.LeaderboardEntry> entries = new ArrayList<org.screamingsandals.bedwars.api.statistics.LeaderboardEntry>();
        this.allScores.entrySet().stream().sorted((c1, c2) -> Comparator.reverseOrder().compare((Integer)((Map.Entry)c1.getValue()).getValue(), (Integer)((Map.Entry)c2.getValue()).getValue())).limit(count).forEach(entry -> entries.add(new LeaderboardEntry(Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey())), (Integer)((Map.Entry)entry.getValue()).getValue(), (String)((Map.Entry)entry.getValue()).getKey())));
        return entries;
    }

    public org.screamingsandals.bedwars.api.statistics.LeaderboardEntry getLeaderboardEntry(int index) {
        return this.allScores.entrySet().stream().sorted((c1, c2) -> Comparator.reverseOrder().compare((Integer)((Map.Entry)c1.getValue()).getValue(), (Integer)((Map.Entry)c2.getValue()).getValue())).skip(index).findFirst().map(entry -> new LeaderboardEntry(Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey())), (Integer)((Map.Entry)entry.getValue()).getValue(), (String)((Map.Entry)entry.getValue()).getKey())).orElse(null);
    }

    private PlayerStatistic loadDatabaseStatistic(UUID uuid) {
        if (this.playerStatistic.containsKey(uuid)) {
            return this.playerStatistic.get(uuid);
        }
        HashMap<String, Object> deserialize = new HashMap<String, Object>();
        try (Connection connection = Main.getDatabaseManager().getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(Main.getDatabaseManager().getReadObjectSql());
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData meta = resultSet.getMetaData();
            while (resultSet.next()) {
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    String key = meta.getColumnName(i);
                    Object value = resultSet.getObject(key);
                    deserialize.put(key, value);
                }
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        PlayerStatistic playerStatistic = deserialize.isEmpty() ? new PlayerStatistic(uuid) : new PlayerStatistic(deserialize);
        Player player = Main.getInstance().getServer().getPlayer(uuid);
        if (player != null && !playerStatistic.getName().equals(player.getName())) {
            playerStatistic.setName(player.getName());
        }
        this.allScores.put(uuid, new AbstractMap.SimpleEntry<String, Integer>(playerStatistic.getName(), playerStatistic.getScore()));
        this.playerStatistic.put(playerStatistic.getId(), playerStatistic);
        return playerStatistic;
    }

    @Override
    public PlayerStatistic loadStatistic(UUID uuid) {
        if (Main.getConfigurator().config.getString("statistics.type").equalsIgnoreCase("database")) {
            return this.loadDatabaseStatistic(uuid);
        }
        return this.loadYamlStatistic(uuid);
    }

    private PlayerStatistic loadYamlStatistic(UUID uuid) {
        if (this.fileDatabase == null || !this.fileDatabase.contains("data." + uuid.toString())) {
            PlayerStatistic playerStatistic = new PlayerStatistic(uuid);
            this.playerStatistic.put(uuid, playerStatistic);
            return playerStatistic;
        }
        Object confSection = this.fileDatabase.get("data." + uuid.toString());
        if (!(confSection instanceof ConfigurationSection) && !(confSection instanceof Map)) {
            Main.getInstance().getLogger().warning("Statistics of player with UUID " + uuid + " are not properly saved and the plugin cannot load them! Expected " + ConfigurationSection.class.getName() + ", got " + (confSection != null ? confSection.getClass().getName() : "null"));
            PlayerStatistic playerStatistic = new PlayerStatistic(uuid);
            this.playerStatistic.put(uuid, playerStatistic);
            return playerStatistic;
        }
        HashMap deserialize = confSection instanceof ConfigurationSection ? new HashMap(((ConfigurationSection)confSection).getValues(false)) : (HashMap)confSection;
        PlayerStatistic playerStatistic = new PlayerStatistic(deserialize);
        playerStatistic.setId(uuid);
        Player player = Main.getInstance().getServer().getPlayer(uuid);
        if (player != null && !playerStatistic.getName().equals(player.getName())) {
            playerStatistic.setName(player.getName());
        }
        this.playerStatistic.put(uuid, playerStatistic);
        this.updateScore(playerStatistic);
        return playerStatistic;
    }

    private void loadYml(File ymlFile) {
        try {
            YamlConfiguration config;
            Main.getInstance().getLogger().info("Loading statistics from YAML-File ...");
            this.databaseFile = ymlFile;
            if (!ymlFile.exists()) {
                ymlFile.getParentFile().mkdirs();
                ymlFile.createNewFile();
                config = new YamlConfiguration();
                config.createSection("data");
                config.save(ymlFile);
            } else {
                config = YamlConfiguration.loadConfiguration((File)ymlFile);
            }
            this.fileDatabase = config;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void storeDatabaseStatistic(PlayerStatistic playerStatistic) {
        try (Connection connection = Main.getDatabaseManager().getConnection();){
            connection.setAutoCommit(false);
            PreparedStatement preparedStatement = connection.prepareStatement(Main.getDatabaseManager().getWriteObjectSql());
            preparedStatement.setString(1, playerStatistic.getId().toString());
            preparedStatement.setString(2, playerStatistic.getName());
            preparedStatement.setInt(3, playerStatistic.getDeaths());
            preparedStatement.setInt(4, playerStatistic.getDestroyedBeds());
            preparedStatement.setInt(5, playerStatistic.getKills());
            preparedStatement.setInt(6, playerStatistic.getLoses());
            preparedStatement.setInt(7, playerStatistic.getScore());
            preparedStatement.setInt(8, playerStatistic.getWins());
            preparedStatement.executeUpdate();
            connection.commit();
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void storeStatistic(PlayerStatistic statistic) {
        BedwarsSavePlayerStatisticEvent savePlayerStatisticEvent = new BedwarsSavePlayerStatisticEvent(statistic);
        Main.getInstance().getServer().getPluginManager().callEvent((Event)savePlayerStatisticEvent);
        if (savePlayerStatisticEvent.isCancelled()) {
            return;
        }
        if (Main.getConfigurator().config.getString("statistics.type").equalsIgnoreCase("database")) {
            this.storeDatabaseStatistic(statistic);
        } else {
            this.storeYamlStatistic(statistic);
        }
    }

    private synchronized void storeYamlStatistic(PlayerStatistic statistic) {
        this.fileDatabase.set("data." + statistic.getId().toString(), null);
        this.fileDatabase.createSection("data." + statistic.getId().toString(), statistic.serialize());
        try {
            this.fileDatabase.save(this.databaseFile);
        }
        catch (Exception ex) {
            Main.getInstance().getLogger().warning("Couldn't store statistic data for player with uuid: " + statistic.getId().toString());
            ex.printStackTrace();
        }
    }

    public void unloadStatistic(OfflinePlayer player) {
        if (Main.getConfigurator().config.getString("statistics.type").equalsIgnoreCase("database")) {
            this.playerStatistic.remove(player.getUniqueId());
        }
    }

    public void updateScore(PlayerStatistic playerStatistic) {
        this.allScores.put(playerStatistic.getId(), new AbstractMap.SimpleEntry<String, Integer>(playerStatistic.getName(), playerStatistic.getScore()));
        if (Main.getLeaderboardHolograms() != null) {
            Main.getLeaderboardHolograms().updateEntries();
        }
    }
}

