/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.tab;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.lib.nms.accessors.ClientboundTabListPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.Component$SerializerAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ComponentAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.RegistryAccessAccessor;
import org.screamingsandals.bedwars.lib.nms.utils.ClassStorage;

public class TabManager {
    private List<String> header;
    private List<String> footer;

    public TabManager() {
        if (Main.getConfigurator().config.getBoolean("tab.header.enabled")) {
            this.header = Main.getConfigurator().config.getStringList("tab.header.contents");
        }
        if (Main.getConfigurator().config.getBoolean("tab.footer.enabled")) {
            this.footer = Main.getConfigurator().config.getStringList("tab.footer.contents").stream().map(content -> ChatColor.translateAlternateColorCodes((char)'&', (String)content)).collect(Collectors.toList());
        }
    }

    public void modifyForPlayer(GamePlayer player) {
        if (player.player.isOnline() && (this.header != null || this.footer != null)) {
            try {
                Object packet;
                Object headerComponent = this.header != null ? TabManager.serialize(ChatColor.translateAlternateColorCodes((char)'&', (String)String.join((CharSequence)"\n", this.translate(player, this.header)))) : TabManager.serialize("");
                Object footerComponent = this.footer != null ? TabManager.serialize(ChatColor.translateAlternateColorCodes((char)'&', (String)String.join((CharSequence)"\n", this.translate(player, this.footer)))) : TabManager.serialize("");
                if (ClientboundTabListPacketAccessor.CONSTRUCTOR_1.get() != null) {
                    packet = ClientboundTabListPacketAccessor.CONSTRUCTOR_1.get().newInstance(headerComponent, footerComponent);
                } else {
                    packet = ClientboundTabListPacketAccessor.CONSTRUCTOR_0.get().newInstance(new Object[0]);
                    ClassStorage.setField(packet, ClientboundTabListPacketAccessor.FIELD_HEADER.get(), headerComponent);
                    ClassStorage.setField(packet, ClientboundTabListPacketAccessor.FIELD_FOOTER.get(), footerComponent);
                }
                ClassStorage.sendPacket(player.player, packet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clear(GamePlayer player) {
        if (player.player.isOnline() && (this.header != null || this.footer != null)) {
            try {
                Object packet;
                String clearString = Main.getVersionNumber() >= 115 ? "{\"text\": \"\"}" : "{\"translate\": \"\"}";
                Object blankComponent = TabManager.serialize(clearString);
                if (ClientboundTabListPacketAccessor.CONSTRUCTOR_1.get() != null) {
                    packet = ClientboundTabListPacketAccessor.CONSTRUCTOR_1.get().newInstance(blankComponent, blankComponent);
                } else {
                    packet = ClientboundTabListPacketAccessor.CONSTRUCTOR_0.get().newInstance(new Object[0]);
                    ClassStorage.setField(packet, ClientboundTabListPacketAccessor.FIELD_HEADER.get(), blankComponent);
                    ClassStorage.setField(packet, ClientboundTabListPacketAccessor.FIELD_FOOTER.get(), blankComponent);
                }
                ClassStorage.sendPacket(player.player, packet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<String> translate(GamePlayer gamePlayer, List<String> origin) {
        ArrayList<String> list = new ArrayList<String>();
        origin.forEach(a -> list.add(a.replace("%players%", String.valueOf(gamePlayer.getGame().countPlayers())).replace("%alive%", String.valueOf(gamePlayer.getGame().countAlive())).replace("%spectating%", String.valueOf(gamePlayer.getGame().getStatus() != GameStatus.WAITING ? gamePlayer.getGame().countSpectating() : gamePlayer.getGame().countPlayers() - gamePlayer.getGame().countRespawnable())).replace("%spectators%", String.valueOf(gamePlayer.getGame().getStatus() != GameStatus.WAITING ? gamePlayer.getGame().countSpectators() : gamePlayer.getGame().countPlayers() - gamePlayer.getGame().countRespawnable())).replace("%respawnable%", String.valueOf(gamePlayer.getGame().countRespawnable())).replace("%max%", String.valueOf(gamePlayer.getGame().getMaxPlayers())).replace("%map%", gamePlayer.getGame().getName())));
        return list;
    }

    public static Object serialize(String text) {
        if (ComponentAccessor.METHOD_LITERAL.get() != null) {
            return ClassStorage.getMethod(ComponentAccessor.METHOD_LITERAL.get()).invokeStatic(text);
        }
        text = text.isEmpty() ? "{\"text\": \"\"}" : "{\"text\": \"" + text.replace("\"", "\\\"") + "\"}";
        if (Component$SerializerAccessor.METHOD_FROM_JSON.get() != null) {
            return ClassStorage.getMethod(Component$SerializerAccessor.METHOD_FROM_JSON.get()).invokeStatic(text);
        }
        if (Component$SerializerAccessor.METHOD_FROM_JSON_1.get() != null) {
            return ClassStorage.getMethod(Component$SerializerAccessor.METHOD_FROM_JSON_1.get()).invokeStatic(text);
        }
        return ClassStorage.getMethod(Component$SerializerAccessor.METHOD_FROM_JSON_LENIENT.get()).invokeStatic(text, RegistryAccessAccessor.FIELD_EMPTY.get());
    }
}

