/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.commands.AdminCommand;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.signmanager.SignBlock;
import org.screamingsandals.bedwars.lib.signmanager.SignOwner;

public class BedWarsSignOwner
implements SignOwner {
    @Override
    public boolean isNameExists(String name) {
        return Main.isGameExists(name) || name.equalsIgnoreCase("leave");
    }

    @Override
    public void updateSign(final SignBlock sign) {
        final String name = sign.getName();
        if (Main.isGameExists(name)) {
            new BukkitRunnable(){

                public void run() {
                    Main.getGame(name).updateSigns();
                }
            }.runTask((Plugin)Main.getInstance());
        } else if ("leave".equalsIgnoreCase(name)) {
            new BukkitRunnable(){

                public void run() {
                    BedWarsSignOwner.this.updateLeaveSign(sign);
                }
            }.runTask((Plugin)Main.getInstance());
        }
    }

    private void updateLeaveSign(SignBlock sign) {
        ArrayList texts = new ArrayList(Main.getConfigurator().config.getStringList("sign"));
        Block block = sign.getLocation().getBlock();
        if (block.getState() instanceof Sign) {
            Sign state = (Sign)block.getState();
            for (int i = 0; i < texts.size(); ++i) {
                String text = (String)texts.get(i);
                state.setLine(i, text.replace("%arena%", I.i18nonly("leave_from_game_item")).replace("%status%", "").replace("%players%", ""));
            }
            state.update();
        }
    }

    @Override
    public List<String> getSignPrefixes() {
        return Arrays.asList("[bedwars]", "[bwgame]");
    }

    @Override
    public void onClick(Player player, SignBlock sign) {
        if (sign.getName().equalsIgnoreCase("leave")) {
            if (Main.isPlayerInGame(player)) {
                Main.getPlayerGameProfile(player).changeGame(null);
            }
        } else {
            Game game = Main.getGame(sign.getName());
            if (game != null) {
                game.joinToGame(player);
            } else {
                I.m("sign_game_not_exists").send(player);
            }
        }
    }

    @Override
    public List<String> getSignCreationPermissions() {
        return AdminCommand.ADMIN_PERMISSION;
    }

    @Override
    public String returnTranslate(String key) {
        return I.i18n(key);
    }
}

