/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.utils;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;

public class BungeeUtils {
    public static void movePlayerToBungeeServer(final Player player, boolean serverRestart) {
        if (serverRestart) {
            BungeeUtils.internalMove(player, true);
            return;
        }
        new BukkitRunnable(){

            public void run() {
                BungeeUtils.internalMove(player, false);
            }
        }.runTask((Plugin)Main.getInstance());
    }

    public static void sendPlayerBungeeMessage(final Player player, final String string) {
        new BukkitRunnable(){

            public void run() {
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeUTF("Message");
                out.writeUTF(player.getName());
                out.writeUTF(string);
                Bukkit.getServer().sendPluginMessage((Plugin)Main.getInstance(), "BungeeCord", out.toByteArray());
            }
        }.runTaskLater((Plugin)Main.getInstance(), 30L);
    }

    private static void internalMove(Player player, boolean restart) {
        try {
            String server = Main.getConfigurator().config.getString("bungee.server");
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("Connect");
            out.writeUTF(server);
            player.sendPluginMessage((Plugin)Main.getInstance(), "BungeeCord", out.toByteArray());
            if (!restart && Main.getConfigurator().config.getBoolean("bungee.kick-when-proxy-too-slow")) {
                Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> {
                    if (player.isOnline()) {
                        player.kickPlayer("Bedwars can't properly transfer player through bungee network. Contact server admin.");
                    }
                }, 20L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

