/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.utils;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.screamingsandals.bedwars.game.GameStore;

public class CitizensUtils {
    public static LivingEntity spawnNPC(GameStore store) {
        if (Bukkit.getPluginManager().isPluginEnabled("Citizens")) {
            try {
                NPCRegistry npcRegistry = CitizensAPI.getNamedNPCRegistry((String)CitizensUtils.class.getName());
                if (npcRegistry == null) {
                    npcRegistry = CitizensAPI.createNamedNPCRegistry((String)CitizensUtils.class.getName(), (NPCDataStore)new MemoryNPCDataStore());
                }
                NPC npc = npcRegistry.createNPC(EntityType.PLAYER, store.getShopCustomName());
                npc.data().set("bedwarsStore", (Object)store);
                if (store.getSkinName() != null) {
                    npc.addTrait(SkinTrait.class);
                    ((SkinTrait)npc.getTraitNullable(SkinTrait.class)).setSkinName(store.getSkinName());
                }
                npc.spawn(store.getStoreLocation(), SpawnReason.PLUGIN);
                return (LivingEntity)npc.getEntity();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static GameStore getFromNPC(Entity entity) {
        if (entity.hasMetadata("NPC") && Bukkit.getPluginManager().isPluginEnabled("Citizens")) {
            try {
                Object object;
                NPC npc;
                NPCRegistry npcRegistry = CitizensAPI.getNamedNPCRegistry((String)CitizensUtils.class.getName());
                if (npcRegistry != null && (npc = npcRegistry.getNPC(entity)) != null && (object = npc.data().get("bedwarsStore")) instanceof GameStore) {
                    return (GameStore)object;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void remove(Entity entity) {
        if (entity.hasMetadata("NPC") && Bukkit.getPluginManager().isPluginEnabled("Citizens")) {
            try {
                NPC npc;
                NPCRegistry npcRegistry = CitizensAPI.getNamedNPCRegistry((String)CitizensUtils.class.getName());
                if (npcRegistry != null && (npc = npcRegistry.getNPC(entity)) != null) {
                    npc.destroy();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

