/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.utils;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.game.TeamColor;
import org.screamingsandals.bedwars.lib.debug.Debug;

public class ColorChanger
implements org.screamingsandals.bedwars.api.utils.ColorChanger {
    public static ItemStack changeLegacyStackColor(ItemStack itemStack, TeamColor teamColor) {
        Material material = itemStack.getType();
        String materialName = material.name();
        if (Main.autoColoredMaterials.contains(materialName)) {
            itemStack.setDurability((short)teamColor.woolData);
        } else if (material.toString().contains("GLASS_PANE")) {
            itemStack.setType(Material.getMaterial((String)"STAINED_GLASS_PANE"));
            itemStack.setDurability((short)teamColor.woolData);
        } else if (material.toString().contains("GLASS")) {
            itemStack.setType(Material.getMaterial((String)"STAINED_GLASS"));
            itemStack.setDurability((short)teamColor.woolData);
        }
        return itemStack;
    }

    public static Material changeMaterialColor(Material material, TeamColor teamColor) {
        String materialName = material.name();
        try {
            materialName = material.toString().substring(material.toString().indexOf("_") + 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        String teamMaterialColor = teamColor.material1_13;
        if (Main.autoColoredMaterials.contains(materialName)) {
            return Material.getMaterial((String)(teamMaterialColor + "_" + materialName));
        }
        if ("GLASS_PANE".equals(material.toString())) {
            return Material.getMaterial((String)(teamMaterialColor + "_STAINED_GLASS_PANE"));
        }
        if ("GLASS".equals(material.toString())) {
            return Material.getMaterial((String)(teamMaterialColor + "_STAINED_GLASS"));
        }
        return material;
    }

    public static ItemStack changeLeatherArmorColor(ItemStack itemStack, TeamColor color) {
        Material material = itemStack.getType();
        if (material.toString().contains("LEATHER_") && !material.toString().contains("LEATHER_HORSE_")) {
            LeatherArmorMeta meta = (LeatherArmorMeta)itemStack.getItemMeta();
            meta.setColor(color.leatherColor);
            itemStack.setItemMeta((ItemMeta)meta);
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public ItemStack applyColor(org.screamingsandals.bedwars.api.TeamColor apiColor, ItemStack stack) {
        try {
            TeamColor color = TeamColor.fromApiColor(apiColor);
            Material material = stack.getType();
            if (Main.isLegacy()) {
                stack = ColorChanger.changeLegacyStackColor(stack, color);
            } else {
                stack.setType(ColorChanger.changeMaterialColor(material, color));
            }
            stack = ColorChanger.changeLeatherArmorColor(stack, color);
            return stack;
        }
        catch (NullPointerException e) {
            Debug.warn("DEFINED ITEM DOES NOT EXISTS. CHECK YOUR CONFIG.");
            e.printStackTrace();
            return new ItemStack(Material.BLACK_WOOL);
        }
    }
}

