/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.TeamColor;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToBoughtItem;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.Team;
import org.screamingsandals.bedwars.lib.debug.Debug;
import org.screamingsandals.bedwars.lib.sgui.utils.MaterialSearchEngine;

public class MiscUtils {
    public static int randInt(int min, int max) {
        Random rand = new Random();
        return rand.nextInt(max - min + 1) + min;
    }

    public static BlockFace getCardinalDirection(Location location) {
        double rotation = (location.getYaw() - 90.0f) % 360.0f;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if (0.0 <= rotation && rotation < 22.5) {
            return BlockFace.NORTH;
        }
        if (22.5 <= rotation && rotation < 67.5) {
            return BlockFace.NORTH_EAST;
        }
        if (67.5 <= rotation && rotation < 112.5) {
            return BlockFace.EAST;
        }
        if (112.5 <= rotation && rotation < 157.5) {
            return BlockFace.SOUTH_EAST;
        }
        if (157.5 <= rotation && rotation < 202.5) {
            return BlockFace.SOUTH;
        }
        if (202.5 <= rotation && rotation < 247.5) {
            return BlockFace.SOUTH_WEST;
        }
        if (247.5 <= rotation && rotation < 292.5) {
            return BlockFace.WEST;
        }
        if (292.5 <= rotation && rotation < 337.5) {
            return BlockFace.NORTH_WEST;
        }
        if (337.5 <= rotation && rotation < 360.0) {
            return BlockFace.NORTH;
        }
        return BlockFace.NORTH;
    }

    public static void sendActionBarMessage(final Player player, final String message) {
        new BukkitRunnable(){

            public void run() {
                if (Main.isSpigot() && !Main.isLegacy() && Main.getConfigurator().config.getBoolean("specials.action-bar-messages")) {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                } else {
                    player.sendMessage(message);
                }
            }
        }.runTask((Plugin)Main.getInstance());
    }

    public static int getIntFromProperty(String name, String fallback, BedwarsApplyPropertyToBoughtItem event) {
        try {
            return event.getIntProperty(name);
        }
        catch (NullPointerException e) {
            return Main.getConfigurator().config.getInt(fallback);
        }
    }

    public static double getDoubleFromProperty(String name, String fallback, BedwarsApplyPropertyToBoughtItem event) {
        try {
            return event.getDoubleProperty(name);
        }
        catch (NullPointerException e) {
            return Main.getConfigurator().config.getDouble(fallback);
        }
    }

    public static boolean getBooleanFromProperty(String name, String fallback, BedwarsApplyPropertyToBoughtItem event) {
        try {
            return event.getBooleanProperty(name);
        }
        catch (NullPointerException e) {
            return Main.getConfigurator().config.getBoolean(fallback);
        }
    }

    public static String getStringFromProperty(String name, String fallback, BedwarsApplyPropertyToBoughtItem event) {
        try {
            return event.getStringProperty(name);
        }
        catch (NullPointerException e) {
            return Main.getConfigurator().config.getString(fallback);
        }
    }

    public static String getMaterialFromProperty(String name, String fallback, BedwarsApplyPropertyToBoughtItem event) {
        try {
            return event.getStringProperty(name);
        }
        catch (NullPointerException e) {
            return Main.getConfigurator().config.getString(fallback, Main.isLegacy() ? "SANDSTONE" : "CUT_SANDSTONE");
        }
    }

    public static MaterialSearchEngine.Result getMaterialFromString(String name, String fallback) {
        if (name != null) {
            MaterialSearchEngine.Result result = MaterialSearchEngine.find(name);
            if (result.getMaterial() == Material.AIR) {
                Debug.warn("Wrong material configured: " + name, true);
            } else {
                return result;
            }
        }
        return MaterialSearchEngine.find(fallback);
    }

    public static Player findTarget(Game game, Player player, double maxDist) {
        Player playerTarget = null;
        RunningTeam team = game.getTeamOfPlayer(player);
        ArrayList<Player> foundTargets = new ArrayList<Player>(game.getConnectedPlayers());
        foundTargets.removeAll(team.getConnectedPlayers());
        for (Player p : foundTargets) {
            double realDistance;
            GamePlayer gamePlayer = Main.getPlayerGameProfile(p);
            if (player.getWorld() != p.getWorld() || gamePlayer.isSpectator || !((realDistance = player.getLocation().distance(p.getLocation())) < maxDist)) continue;
            playerTarget = p;
            maxDist = realDistance;
        }
        return playerTarget;
    }

    public static Location readLocationFromString(World world, String location) {
        int lpos = 0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float yaw = 0.0f;
        float pitch = 0.0f;
        block7: for (String pos : location.split(";")) {
            switch (++lpos) {
                case 1: {
                    x = Double.parseDouble(pos);
                    continue block7;
                }
                case 2: {
                    y = Double.parseDouble(pos);
                    continue block7;
                }
                case 3: {
                    z = Double.parseDouble(pos);
                    continue block7;
                }
                case 4: {
                    yaw = Float.parseFloat(pos);
                    continue block7;
                }
                case 5: {
                    pitch = Float.parseFloat(pos);
                    continue block7;
                }
            }
        }
        return new Location(world, x, y, z, yaw, pitch);
    }

    public static String setLocationToString(Location location) {
        return location.getX() + ";" + location.getY() + ";" + location.getZ() + ";" + location.getYaw() + ";" + location.getPitch();
    }

    public static String convertColorToNewFormat(String oldColor, Team team) {
        String newColor = oldColor;
        if (team.isNewColor()) {
            return oldColor;
        }
        switch (oldColor) {
            case "DARK_BLUE": {
                newColor = "BLUE";
                break;
            }
            case "DARK_GREEN": {
                newColor = "GREEN";
                break;
            }
            case "DARK_PURPLE": {
                newColor = "MAGENTA";
                break;
            }
            case "GOLD": {
                newColor = "ORANGE";
                break;
            }
            case "GRAY": {
                newColor = "LIGHT_GRAY";
                break;
            }
            case "BLUE": {
                newColor = "LIGHT_BLUE";
                break;
            }
            case "GREEN": {
                newColor = "LIME";
                break;
            }
            case "AQUA": {
                newColor = "CYAN";
                break;
            }
            case "LIGHT_PURPLE": {
                newColor = "PINK";
                break;
            }
            case "DARK_RED": {
                newColor = "BROWN";
                break;
            }
            case "DARK_GRAY": {
                newColor = "GRAY";
            }
        }
        return newColor;
    }

    public static Vector getDirection(BlockFace face) {
        int modX = face.getModX();
        int modY = face.getModY();
        int modZ = face.getModZ();
        Vector direction = new Vector(modX, modY, modZ);
        if (modX != 0 || modY != 0 || modZ != 0) {
            direction.normalize();
        }
        return direction;
    }

    public static void giveItemsToPlayer(List<ItemStack> itemStackList, Player player, TeamColor teamColor) {
        for (ItemStack itemStack : itemStackList) {
            String materialName = itemStack.getType().toString();
            PlayerInventory playerInventory = player.getInventory();
            if (materialName.contains("HELMET")) {
                playerInventory.setHelmet(Main.applyColor(teamColor, itemStack));
                continue;
            }
            if (materialName.contains("CHESTPLATE")) {
                playerInventory.setChestplate(Main.applyColor(teamColor, itemStack));
                continue;
            }
            if (materialName.contains("LEGGINGS")) {
                playerInventory.setLeggings(Main.applyColor(teamColor, itemStack));
                continue;
            }
            if (materialName.contains("BOOTS")) {
                playerInventory.setBoots(Main.applyColor(teamColor, itemStack));
                continue;
            }
            playerInventory.addItem(new ItemStack[]{Main.applyColor(teamColor, itemStack)});
        }
    }

    public static Location findEmptyLocation(Location respawnLocation) {
        if (respawnLocation.getY() > (double)(respawnLocation.getWorld().getMaxHeight() - 1) || !respawnLocation.getBlock().getType().isSolid() && !respawnLocation.clone().add(0.0, 1.0, 0.0).getBlock().getType().isSolid()) {
            return respawnLocation;
        }
        return MiscUtils.findEmptyLocation(respawnLocation.clone().add(0.0, 2.0, 0.0));
    }

    public static List<Player> getOnlinePlayers(Set<UUID> members) {
        return members.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

