/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.lib.lang.I;

public class UpdateChecker {
    public static void run() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
            try {
                URL url = new URL("https://screamingsandals.org/bedwars-zero-update-checker.php?version=" + Main.getVersion());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "SpigetResourceUpdater");
                JsonObject jsonObject = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonObject();
                Result result = (Result)new Gson().fromJson((JsonElement)jsonObject, Result.class);
                if ("ok".equalsIgnoreCase(result.status)) {
                    UpdateListener updateListener = null;
                    if (result.isUpdateAvailable) {
                        if (Main.getConfigurator().config.getBoolean("update-checker.zero.console")) {
                            I.mpr("update_checker_zero").replace("version", result.currentZeroVersion).send(Bukkit.getConsoleSender());
                            I.mpr("update_checker_zero_second").replace("url", result.download).send(Bukkit.getConsoleSender());
                        }
                        if (Main.getConfigurator().config.getBoolean("update-checker.zero.admins")) {
                            updateListener = new UpdateListener(result);
                            Bukkit.getPluginManager().registerEvents((Listener)updateListener, (Plugin)Main.getInstance());
                        }
                    }
                    if (result.isOneAvailable) {
                        float javaVer = Float.parseFloat(System.getProperty("java.class.version"));
                        if (Main.getConfigurator().config.getBoolean("update-checker.one.console")) {
                            I.mpr("update_checker_one").replace("url", result.oneWebsite).send(Bukkit.getConsoleSender());
                            if (javaVer < 55.0f) {
                                I.mpr("update_checker_one_second_bad").send(Bukkit.getConsoleSender());
                            } else {
                                I.mpr("update_checker_one_second_good").send(Bukkit.getConsoleSender());
                            }
                        }
                        if (Main.getConfigurator().config.getBoolean("update-checker.one.admins")) {
                            if (updateListener == null) {
                                updateListener = new UpdateListener(result);
                                Bukkit.getPluginManager().registerEvents((Listener)updateListener, (Plugin)Main.getInstance());
                            }
                            updateListener.javaVer = javaVer;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static class Result {
        public String status;
        @SerializedName(value="version")
        public String currentZeroVersion;
        @SerializedName(value="zero_update")
        public boolean isUpdateAvailable;
        @SerializedName(value="one_available")
        public boolean isOneAvailable;
        @SerializedName(value="one_page")
        public String oneWebsite;
        @SerializedName(value="zero_download_url")
        public String download;

        public String toString() {
            return "Result{status=" + this.status + ", currentZeroVersion='" + this.currentZeroVersion + '\'' + ", isUpdateAvailable=" + this.isUpdateAvailable + ", isOneAvailable=" + this.isOneAvailable + ", oneWebsite='" + this.oneWebsite + '\'' + ", download='" + this.download + '\'' + '}';
        }
    }

    public static class UpdateListener
    implements Listener {
        public float javaVer;
        private Result result;

        public UpdateListener(Result result) {
            this.result = result;
        }

        @EventHandler
        public void onPlayerJoin(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            if (BaseCommand.hasPermission((CommandSender)player, BaseCommand.ADMIN_PERMISSION, false)) {
                if (Main.getConfigurator().config.getBoolean("update-checker.zero.admins") && this.result.isUpdateAvailable) {
                    I.mpr("update_checker_zero").replace("version", this.result.currentZeroVersion).send(player);
                    I.mpr("update_checker_zero_second").replace("url", this.result.download).send(player);
                }
                if (Main.getConfigurator().config.getBoolean("update-checker.one.admins") && this.result.isOneAvailable) {
                    I.mpr("update_checker_one").replace("url", this.result.oneWebsite).send(player);
                    if (this.javaVer < 55.0f) {
                        I.mpr("update_checker_one_second_bad").send(player);
                    } else {
                        I.mpr("update_checker_one_second_good").send(player);
                    }
                }
            }
        }
    }
}

