/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.screamingsandals.bedwars.lib.nms.accessors.MinecraftServerAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.MinecraftServerMapping;
import org.screamingsandals.bedwars.lib.takenaka.accessor.platform.MapperPlatform;
import org.screamingsandals.bedwars.lib.takenaka.accessor.platform.MapperPlatforms;

public final class VersionFallback {
    public static void applyFallbackIfNeeded() {
        Object[] mappingNamespaces = MapperPlatforms.getCurrentPlatform().getMappingNamespaces();
        String version = MapperPlatforms.getCurrentPlatform().getVersion();
        if (MinecraftServerAccessor.TYPE.get() != null) {
            Bukkit.getLogger().info("[BedWars] Loaded NMS modules for " + version + " in namespaces " + Arrays.toString(mappingNamespaces));
            return;
        }
        List<String> usedNamespaces = Arrays.asList(mappingNamespaces);
        String latest = MinecraftServerMapping.MAPPING.getMappings().entrySet().stream().filter(entry -> usedNamespaces.stream().anyMatch(e -> ((Map)entry.getValue()).containsKey(e))).map(Map.Entry::getKey).max(VersionFallback::compareVersions).orElse(null);
        if (latest == null) {
            return;
        }
        if (VersionFallback.compareVersions(version, latest) <= 0) {
            Bukkit.getLogger().severe("[BedWars] Version " + version + " is incompatible with Screaming BedWars!");
            return;
        }
        MapperPlatforms.setCurrentPlatform(MapperPlatform.create(latest, MapperPlatforms.getCurrentPlatform().getClassLoader(), (String[])mappingNamespaces));
        Bukkit.getLogger().warning("[BedWars] ==========================");
        Bukkit.getLogger().warning("[BedWars] This Minecraft version (" + version + ") is newer than the latest supported version (" + latest + ").");
        Bukkit.getLogger().warning("[BedWars] Attempting to use the latest known mappings. This is only safe if the newer Minecraft version is a bugfix release.");
        Bukkit.getLogger().warning("[BedWars] Unless we confirm compatibility, do NOT run this version and wait for an update.");
        Bukkit.getLogger().warning("[BedWars] ==========================");
        Bukkit.getLogger().info("[BedWars] Loaded fallback NMS modules for " + latest + " in namespaces " + Arrays.toString(mappingNamespaces));
    }

    private static int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 == num2) continue;
            return Integer.compare(num1, num2);
        }
        return 0;
    }

    @Generated
    private VersionFallback() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

