/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.mixin;

import java.util.Collection;
import java.util.List;
import me.cominixo.betterf3.config.GeneralOptions;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.gui.components.debug.DebugEntryNoop;
import net.minecraft.client.gui.components.debug.DebugScreenEntries;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.client.gui.components.debug.DebugScreenEntryList;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugScreenOverlay.class})
public abstract class DebugMixin {
    @Final
    @Shadow
    private Minecraft minecraft;
    @Unique
    private static final ResourceLocation BETTERF3_RESOURCE = DebugScreenEntries.register((String)"betterf3", (DebugScreenEntry)new DebugEntryNoop());
    @Unique
    private static final List<ResourceLocation> BETTERF3_LIST = List.of(BETTERF3_RESOURCE);

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="HEAD")})
    public void renderBefore(GuiGraphics context, CallbackInfo ci) {
        if (GeneralOptions.disableMod || !this.minecraft.debugEntries.isF3Visible()) {
            return;
        }
        context.pose().pushMatrix();
    }

    @Redirect(method={"render(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/debug/DebugScreenEntryList;getCurrentlyEnabled()Ljava/util/Collection;"))
    private Collection<ResourceLocation> currentlyEnabled(DebugScreenEntryList instance) {
        if (!GeneralOptions.disableMod && this.minecraft.debugEntries.isF3Visible()) {
            return BETTERF3_LIST;
        }
        return instance.getCurrentlyEnabled();
    }

    @Redirect(method={"render(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/debug/DebugScreenEntryList;isF3Visible()Z"))
    private boolean isF3Visible(DebugScreenEntryList instance) {
        if (!GeneralOptions.disableMod && this.minecraft.debugEntries.isF3Visible()) {
            return false;
        }
        return instance.isF3Visible();
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/debug/DebugScreenEntryList;getCurrentlyEnabled()Ljava/util/Collection;", shift=At.Shift.AFTER)})
    public void renderFontScaleBefore(GuiGraphics context, CallbackInfo ci) {
        if (!GeneralOptions.disableMod && this.minecraft.debugEntries.isF3Visible()) {
            context.pose().scale((float)GeneralOptions.fontScale, (float)GeneralOptions.fontScale);
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V")})
    public synchronized void renderAnimation(GuiGraphics context, CallbackInfo ci) {
        if (GeneralOptions.disableMod) {
            return;
        }
        if (!GeneralOptions.enableAnimations) {
            return;
        }
        long time = Util.getMillis();
        if (time - Utils.lastAnimationUpdate >= 10L && (Utils.xPos != 0 || Utils.closingAnimation)) {
            int i = (100 + Utils.xPos) / 10 - 9;
            if (Utils.xPos != 0 && !Utils.closingAnimation) {
                Utils.xPos = (int)((double)Utils.xPos / GeneralOptions.animationSpeed);
                Utils.xPos -= i;
            }
            if (i == 0) {
                i = 1;
            }
            if (Utils.closingAnimation) {
                Utils.xPos += i;
                if ((Utils.xPos = (int)((double)Utils.xPos * GeneralOptions.animationSpeed)) >= 300) {
                    this.minecraft.debugEntries.setF3Visible(false);
                    Utils.closingAnimation = false;
                }
            }
            Utils.lastAnimationUpdate = time;
        }
    }
}

