/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.mixin.autof3;

import me.cominixo.betterf3.config.GeneralOptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DebugScreenOverlay.class})
public abstract class DebugOptionMixin {
    @Shadow
    public boolean renderFpsCharts;
    @Shadow
    public boolean renderProfilerChart;
    @Final
    @Shadow
    private Minecraft minecraft;

    @Shadow
    public abstract void toggleNetworkCharts();

    @Inject(method={"<init>(Lnet/minecraft/client/Minecraft;)V"}, at={@At(value="RETURN")})
    public void addAutomaticDebugOption(Minecraft minecraft, CallbackInfo ci) {
        if (!GeneralOptions.disableMod && GeneralOptions.autoF3) {
            this.minecraft.debugEntries.setF3Visible(true);
            if (GeneralOptions.alwaysEnableProfiler) {
                this.renderProfilerChart = true;
            }
            if (GeneralOptions.alwaysEnableTPS) {
                this.renderFpsCharts = true;
            }
            if (GeneralOptions.alwaysEnablePing) {
                this.toggleNetworkCharts();
            }
        }
    }

    @Inject(method={"reset()V"}, at={@At(value="RETURN")})
    private void automaticF3(CallbackInfo ci) {
        if (!GeneralOptions.disableMod && GeneralOptions.autoF3) {
            this.minecraft.debugEntries.setF3Visible(true);
            if (GeneralOptions.alwaysEnableProfiler) {
                this.renderProfilerChart = true;
            }
            if (GeneralOptions.alwaysEnableTPS) {
                this.renderFpsCharts = true;
            }
            if (GeneralOptions.alwaysEnablePing) {
                this.toggleNetworkCharts();
            }
        }
    }

    @Inject(method={"showDebugScreen()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldRenderDebug(CallbackInfoReturnable<Boolean> cir) {
        if (!GeneralOptions.disableMod && GeneralOptions.autoF3 && this.minecraft.debugEntries.isF3Visible() && !this.minecraft.options.hideGui) {
            cir.setReturnValue((Object)(this.minecraft.level != null ? 1 : 0));
        }
    }
}

