/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.List;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NaturalSpawner;

public class EntityModule
extends BaseModule {
    public TextColor totalColor;
    public final TextColor defaultTotalColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GOLD);

    public EntityModule() {
        this.defaultNameColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED);
        this.defaultValueColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.YELLOW);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.totalColor = this.defaultTotalColor;
        this.lines.add(new DebugLine("particles"));
        this.lines.add(new DebugLine("entities", "format.betterf3.total", true));
        for (MobCategory spawnGroup : MobCategory.values()) {
            String name = spawnGroup.toString().toLowerCase();
            this.lines.add(new DebugLine(name));
        }
        ((DebugLine)this.lines.get((int)0)).inReducedDebug = true;
        ((DebugLine)this.lines.get((int)1)).inReducedDebug = true;
    }

    @Override
    public void update(Minecraft client) {
        if (client.levelRenderer.level == null) {
            return;
        }
        List<Component> entityValues = Arrays.asList(Utils.styledText(I18n.get((String)"text.betterf3.line.rendered", (Object[])new Object[0]), this.valueColor), Utils.styledText(I18n.get((String)"text.betterf3.line.total", (Object[])new Object[0]), this.totalColor), Utils.styledText(client.gameRenderer.getLevelRenderState().entityRenderStates.size(), this.valueColor), Utils.styledText(client.levelRenderer.level.getEntityCount(), this.totalColor));
        IntegratedServer integratedServer = client.getSingleplayerServer();
        if (client.level != null) {
            NaturalSpawner.SpawnState info;
            ServerLevel serverWorld;
            ServerLevel serverLevel = serverWorld = integratedServer != null ? integratedServer.getLevel(client.level.dimension()) : null;
            if (serverWorld != null && (info = serverWorld.getChunkSource().getLastSpawnState()) != null) {
                Object2IntMap spawnGroupCount = info.getMobCategoryCounts();
                for (int i = 0; i < MobCategory.values().length; ++i) {
                    MobCategory group = MobCategory.values()[i];
                    while (this.lines.size() <= i + 2) {
                        DebugLine debugLine = new DebugLine(group.toString().toLowerCase());
                        debugLine.name(group.getName());
                        this.lines.add(debugLine);
                    }
                    ((DebugLine)this.lines.get(i + 2)).value(spawnGroupCount.getInt((Object)group));
                }
            }
        }
        ((DebugLine)this.lines.get(0)).value(client.particleEngine.countParticles());
        ((DebugLine)this.lines.get(1)).value(entityValues);
    }
}

