/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import java.util.ArrayList;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.DebugLineList;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class TargetModule
extends BaseModule {
    public TargetModule() {
        this.defaultNameColor = TextColor.fromRgb((int)43775);
        this.defaultValueColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.YELLOW);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.lines.add(new DebugLine("targeted_block"));
        this.lines.add(new DebugLine("id_block"));
        this.lines.add(new DebugLineList("block_states"));
        this.lines.add(new DebugLineList("block_tags"));
        this.lines.add(new DebugLine("nothing"));
        this.lines.add(new DebugLine("targeted_fluid"));
        this.lines.add(new DebugLine("id_fluid"));
        this.lines.add(new DebugLineList("fluid_states"));
        this.lines.add(new DebugLineList("fluid_tags"));
        this.lines.add(new DebugLine("nothing2"));
        this.lines.add(new DebugLine("targeted_entity"));
    }

    @Override
    public void update(@NotNull Minecraft client) {
        BlockPos blockPos;
        Entity cameraEntity = client.getCameraEntity();
        if (cameraEntity == null) {
            return;
        }
        HitResult blockHit = cameraEntity.pick(20.0, 0.0f, false);
        HitResult fluidHit = cameraEntity.pick(20.0, 0.0f, true);
        if (blockHit.getType() == HitResult.Type.BLOCK) {
            blockPos = ((BlockHitResult)blockHit).getBlockPos();
            if (client.level == null) {
                return;
            }
            BlockState blockState = client.level.getBlockState(blockPos);
            ((DebugLine)this.lines.get(0)).value(blockPos.getX() + ", " + blockPos.getY() + ", " + blockPos.getZ());
            ((DebugLine)this.lines.get(1)).value(String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())));
            ArrayList<String> blockStates = new ArrayList<String>();
            blockState.getValues().entrySet().forEach(entry -> blockStates.add(Utils.propertyToString(entry)));
            ((DebugLineList)this.lines.get(2)).values(blockStates);
            ArrayList<String> blockTags = new ArrayList<String>();
            blockState.getTags().map(arg -> "#" + String.valueOf(arg.location())).forEach(blockTags::add);
            ((DebugLineList)this.lines.get(3)).values(blockTags);
        } else {
            for (int i = 0; i < 5; ++i) {
                ((DebugLine)this.lines.get((int)i)).active = false;
            }
        }
        if (fluidHit.getType() == HitResult.Type.BLOCK) {
            blockPos = ((BlockHitResult)fluidHit).getBlockPos();
            if (client.level == null) {
                return;
            }
            FluidState fluidState = client.level.getFluidState(blockPos);
            ((DebugLine)this.lines.get(5)).value(blockPos.getX() + ", " + blockPos.getY() + ", " + blockPos.getZ());
            ((DebugLine)this.lines.get(6)).value(BuiltInRegistries.FLUID.getKey((Object)fluidState.getType()));
            ArrayList<String> fluidStates = new ArrayList<String>();
            fluidState.getValues().entrySet().forEach(entry -> fluidStates.add(Utils.propertyToString(entry)));
            ((DebugLineList)this.lines.get(7)).values(fluidStates);
            ArrayList<String> fluidTags = new ArrayList<String>();
            fluidState.getTags().map(arg -> "#" + String.valueOf(arg.location())).forEach(fluidTags::add);
            ((DebugLineList)this.lines.get(8)).values(fluidTags);
        } else {
            for (int i = 5; i < 10; ++i) {
                ((DebugLine)this.lines.get((int)i)).active = false;
            }
        }
        Entity entity = client.crosshairPickEntity;
        if (entity != null) {
            ((DebugLine)this.lines.get(10)).value(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()));
        } else {
            ((DebugLine)this.lines.get((int)10)).active = false;
        }
    }
}

