/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.utils;

import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.Nullable;

public class DebugLine {
    private Object value;
    private String format;
    private final String id;
    @Nullable
    private String name = null;
    public boolean active = true;
    public boolean enabled = true;
    public boolean isCustom = false;
    public boolean inReducedDebug = false;

    public DebugLine(String id) {
        this.id = id;
        this.format = "format.betterf3.default_format";
        this.value = "";
    }

    public DebugLine(String id, String formatString, boolean isCustom) {
        this.id = id;
        this.value = "";
        this.format = formatString;
        this.isCustom = isCustom;
    }

    public Component toText(TextColor nameColor, TextColor valueColor) {
        String name = this.name();
        MutableComponent nameStyled = Utils.styledText(name, nameColor);
        Object valueStyled = this.value instanceof Component ? (Component)this.value : Utils.styledText(this.value, valueColor);
        if (this.value.toString().isEmpty()) {
            this.active = false;
        }
        return Component.translatable((String)this.format, (Object[])new Object[]{nameStyled, valueStyled});
    }

    public Component toTextCustom(TextColor nameColor) {
        String name = this.name();
        Object object = this.value;
        if (object instanceof List) {
            List listValue = (List)object;
            ArrayList<MutableComponent> values = new ArrayList<MutableComponent>();
            if (!name.isEmpty()) {
                values.add(Utils.styledText(name, nameColor));
            }
            values.addAll(listValue);
            return Component.translatable((String)this.format, (Object[])values.toArray()).withStyle(style -> style.withColor(nameColor));
        }
        return Component.translatable((String)this.format, (Object[])new Object[]{name, this.value});
    }

    public void value(Object value) {
        this.active = true;
        this.value = value;
    }

    public void format(String format) {
        this.format = format;
    }

    public String name() {
        if (this.name != null) {
            return this.name;
        }
        if (this.id.isEmpty()) {
            this.format = "%s%s";
            return "";
        }
        Language language = Language.getInstance();
        return language.getOrDefault("text.betterf3.line." + this.id);
    }

    public void name(String name) {
        this.name = name;
    }

    public String id() {
        return this.id;
    }
}

