/*
 * Decompiled with CFR 0.152.
 */
package me.treyruffy.betterf3;

import me.cominixo.betterf3.config.ModConfigFile;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.ChunksModule;
import me.cominixo.betterf3.modules.CoordsModule;
import me.cominixo.betterf3.modules.EmptyModule;
import me.cominixo.betterf3.modules.EntityModule;
import me.cominixo.betterf3.modules.FpsModule;
import me.cominixo.betterf3.modules.GraphicsModule;
import me.cominixo.betterf3.modules.HelpModule;
import me.cominixo.betterf3.modules.LocationModule;
import me.cominixo.betterf3.modules.MinecraftModule;
import me.cominixo.betterf3.modules.MiscLeftModule;
import me.cominixo.betterf3.modules.MiscRightModule;
import me.cominixo.betterf3.modules.ServerModule;
import me.cominixo.betterf3.modules.SoundModule;
import me.cominixo.betterf3.modules.SystemModule;
import me.cominixo.betterf3.modules.TargetModule;
import me.cominixo.betterf3.utils.PositionEnum;
import me.cominixo.betterf3.utils.Utils;
import me.treyruffy.betterf3.NeoForgeModMenu;
import net.minecraft.client.resources.language.I18n;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="betterf3")
public class BetterF3NeoForge {
    private static final Logger LOGGER = LogManager.getLogger();

    public BetterF3NeoForge(IEventBus eventBus) {
        LOGGER.info("[BetterF3] Starting...");
        if (FMLEnvironment.getDist() == Dist.DEDICATED_SERVER) {
            LOGGER.warn("[BetterF3] Not supported on dedicated server!");
        } else {
            ClientSetup.setup(eventBus);
        }
    }

    private static final class ClientSetup {
        private ClientSetup() {
        }

        private static void setup(IEventBus eventBus) {
            ClientSetup.setupModules();
            if (ModList.get().isLoaded("cloth_config")) {
                NeoForgeModMenu.registerModsPage();
            } else {
                LOGGER.info(I18n.get((String)"config.betterf3.need_cloth_config", (Object[])new Object[0]));
            }
        }

        private static void setupModules() {
            LOGGER.info("[BetterF3] Loading...");
            Utils.modVersion(ClientSetup.modVersion());
            new MinecraftModule().init();
            new FpsModule().init();
            new GraphicsModule().init();
            new ServerModule().init();
            new CoordsModule().init();
            new ChunksModule().init();
            new LocationModule().init();
            new EntityModule().init();
            new SoundModule().init();
            new HelpModule().init();
            BaseModule.modules.add(new EmptyModule(false));
            new MiscLeftModule().init();
            new SystemModule().init(PositionEnum.RIGHT);
            new MiscRightModule().init(PositionEnum.RIGHT);
            BaseModule.modulesRight.add(new EmptyModule(false));
            new TargetModule().init(PositionEnum.RIGHT);
            ModConfigFile.load(ModConfigFile.FileType.TOML);
            LOGGER.info("[BetterF3] All done!");
        }

        private static String modVersion() {
            return ((ModContainer)ModList.get().getModContainerById("betterf3").orElseThrow(NullPointerException::new)).getModInfo().getVersion().toString();
        }
    }
}

