/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.utils;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.GeneralOptions;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.MiscLeftModule;
import me.cominixo.betterf3.modules.MiscRightModule;
import me.cominixo.betterf3.utils.PositionEnum;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public final class DebugRenderer {
    private DebugRenderer() {
    }

    public static void drawBackground(class_310 minecraft, class_327 font, PositionEnum pos, List<class_2561> list, class_332 guiGraphics) {
        for (int i = 0; i < list.size(); ++i) {
            int j;
            int x2;
            int x1;
            int height = 9;
            int width = font.method_1727(list.get(i).getString());
            if (width == 0) continue;
            int y = 2 + 9 * i;
            if (pos == PositionEnum.RIGHT) {
                windowWidth = (int)((double)minecraft.method_22683().method_4486() / GeneralOptions.fontScale) - 2 - width;
                if (GeneralOptions.enableAnimations) {
                    windowWidth += Utils.xPos;
                }
                x1 = windowWidth - 1;
                x2 = windowWidth + width + 1;
            } else {
                windowWidth = 2;
                if (GeneralOptions.enableAnimations) {
                    windowWidth -= Utils.xPos;
                }
                x1 = windowWidth - 1;
                x2 = width + 1 + windowWidth;
            }
            int y1 = y - 1;
            int y2 = y + 9 - 1;
            if (x1 < x2) {
                j = x1;
                x1 = x2;
                x2 = j;
            }
            if (y1 < y2) {
                j = y1;
                y1 = y2;
                y2 = j;
            }
            guiGraphics.method_25294(x1, y1, x2, y2, GeneralOptions.backgroundColor);
        }
    }

    public static void drawRightText(List<class_2561> list, class_332 guiGraphics, class_310 minecraft, class_327 font, @Nullable List<String> additional) {
        if (additional != null) {
            additional.forEach(text -> list.add(class_2561.method_30163((String)text)));
        }
        DebugRenderer.drawBackground(minecraft, font, PositionEnum.RIGHT, list, guiGraphics);
        for (int i = 0; i < list.size(); ++i) {
            if (Strings.isNullOrEmpty((String)list.get(i).getString())) continue;
            int height = 9;
            int width = font.method_1727(list.get(i).getString());
            int windowWidth = (int)((double)minecraft.method_22683().method_4486() / GeneralOptions.fontScale) - 2 - width;
            if (GeneralOptions.enableAnimations) {
                windowWidth += Utils.xPos;
            }
            int y = 2 + 9 * i;
            guiGraphics.method_51439(font, list.get(i), windowWidth, y, -2039584, GeneralOptions.shadowText);
        }
        guiGraphics.method_51448().popMatrix();
    }

    public static void drawLeftText(List<class_2561> list, class_332 guiGraphics, class_310 minecraft, class_327 font, @Nullable List<String> additional) {
        if (additional != null) {
            additional.forEach(text -> list.add(class_2561.method_30163((String)text)));
        }
        DebugRenderer.drawBackground(minecraft, font, PositionEnum.LEFT, list, guiGraphics);
        for (int i = 0; i < list.size(); ++i) {
            if (Strings.isNullOrEmpty((String)list.get(i).getString())) continue;
            int height = 9;
            int y = 2 + 9 * i;
            int xPosLeft = 2;
            if (GeneralOptions.enableAnimations) {
                xPosLeft -= Utils.xPos;
            }
            guiGraphics.method_51439(font, list.get(i), xPosLeft, y, -2039584, GeneralOptions.shadowText);
        }
    }

    public static List<class_2561> newText(class_310 minecraft, boolean left, List<String> gameInformation, List<String> systemInformation) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        if (minecraft.field_1687 == null) {
            return list;
        }
        for (BaseModule module : left ? BaseModule.modules : BaseModule.modulesRight) {
            if (!module.enabled) continue;
            if (module instanceof MiscRightModule) {
                ((MiscRightModule)module).update(systemInformation);
            } else if (module instanceof MiscLeftModule) {
                ((MiscLeftModule)module).update(gameInformation);
            } else {
                module.update(minecraft);
            }
            list.addAll(module.linesFormatted(minecraft.method_1555()));
            if (!GeneralOptions.spaceEveryModule) continue;
            list.add(class_2561.method_30163((String)""));
        }
        return list;
    }
}

