#version 150

uniform sampler2D DiffuseSampler;
uniform vec2 OutSize;

uniform vec2 center;
uniform float radius;
uniform float softness;
uniform float intensity;
uniform vec3 lightColor;
uniform float hotspotRadius;
uniform float hotspotSoftness;
uniform float hotspotIntensity;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec4 base = texture(DiffuseSampler, texCoord);
    vec2 uv = texCoord;
    vec2 c = center;
    vec2 aspect = vec2(OutSize.x / OutSize.y, 1.0);
    vec2 diff = (uv - c) * aspect;
    float d = length(diff);
    float mask = 1.0 - smoothstep(radius, radius + softness, d);
    float innerMask = 1.0 - smoothstep(hotspotRadius, hotspotRadius + hotspotSoftness, d);
    vec3 result = base.rgb;
    result *= 1.0 + intensity * mask;
    float hotspotBoost = 1.0 + hotspotIntensity * innerMask;
    result *= hotspotBoost;
    result = mix(result, result * lightColor, 0.25 * innerMask);
    result = min(result, vec3(1.0));
    fragColor = vec4(result, base.a);
}


