#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D PrevSampler;

in vec2 texCoord;
in vec2 oneTexel;

uniform vec2 InSize;
uniform float Time;
uniform float FpsLimit = 10.0;

out vec4 fragColor;

void main() {
    vec4 CurrTexel = texture(DiffuseSampler, texCoord);
    vec4 PrevTexel = texture(PrevSampler, texCoord);
    
    float frameInterval = 1.0 / FpsLimit;
    float frameTime = floor(Time / frameInterval) * frameInterval;
    float frameFactor = mod(Time, frameInterval) / frameInterval;
    
    if (frameFactor < 0.5) {
        fragColor = PrevTexel;
    } else {
        fragColor = CurrTexel;
    }
    
    fragColor.w = 1.0;
} 