#version 150

uniform sampler2D DiffuseSampler;
uniform vec2 OutSize;

uniform float edgeThreshold;
uniform float edgeIntensity;
uniform vec3 outlineColor;

in vec2 texCoord;
out vec4 fragColor;

const float sobelX[9] = float[](
    -1.0, 0.0, 1.0,
    -2.0, 0.0, 2.0,
    -1.0, 0.0, 1.0
);

const float sobelY[9] = float[](
    -1.0, -2.0, -1.0,
     0.0,  0.0,  0.0,
     1.0,  2.0,  1.0
);

void main() {
    vec2 texelSize = 1.0 / OutSize;
    
    float gx = 0.0;
    float gy = 0.0;
    
    for (int i = 0; i < 9; i++) {
        int x = i % 3 - 1;
        int y = i / 3 - 1;
        
        vec2 offset = vec2(float(x), float(y)) * texelSize;
        vec3 sample = texture(DiffuseSampler, texCoord + offset).rgb;
        
        float luminance = dot(sample, vec3(0.299, 0.587, 0.114));
        
        gx += luminance * sobelX[i];
        gy += luminance * sobelY[i];
    }
    
    float edgeMagnitude = sqrt(gx * gx + gy * gy);
    
    float edge = smoothstep(edgeThreshold, edgeThreshold + 0.05, edgeMagnitude) * edgeIntensity;
    
    edge = edge * edge;
    
    fragColor = vec4(outlineColor * edge, edge);
}