include(Resources.id("jsblock:scripts/pids_util.js"));

function create(ctx, state, pids) {
}

function render(ctx, state, pids) {
    let arrival_1 = pids.arrivals().get(0);
    let arrival_2 = pids.arrivals().get(1);

    Texture.create("Background")
    .texture("jsblock:custom_directory/parail_modern.png")
    .size(pids.width, pids.height)
    .draw(ctx);

    
    if(arrival_1 != null) {
        
    Text.create("Arrival 1 Dest")
        .text(TextUtil.cycleString(arrival_1.destination()))
        .pos(46, 18)
        .size(80, 9)
        .marquee()
        .color(0x000000)
        .draw(ctx);

        let etas = arrival_1.departureTime()
        let eta = new Date(etas)
        let hours = eta.getHours()
        let minutes = eta.getMinutes()
        let time = hours.toString().padStart(2, '0') + ":" + minutes.toString().padStart(2, '0');
        Text.create("arrival_first ETA")
        .text(time)
        .pos(46, 12)
        .color(0x000000)
        .scale(0.5)
        .draw(ctx);
        
    Text.create("Clock")
        .text(PIDSUtil.formatTime(MinecraftClient.worldDayTime(), true))
        .pos(115, 68)
        .color(0xffffff)
        .scale(0.75)
        .draw(ctx);

    Text.create("Platform")
    .text("Platform")
    .color(0x000000)
    .pos(8, 22)
    .scale(0.5)
    .draw(ctx);

    Text.create("PlatNum")
    .text(arrival_1.platformName())
    .color(0x000000)
    .pos(8, 26)
    .size(10, 9)
    .scale(2)
    .scaleXY()
    .draw(ctx);

    Text.create("Station Name")
        .pos(30, 68)
        .text(pids.station().getName().replace("|", " "))
        .size(75, 10)
        .marquee()
        .scale(0.75)
        .color(0xFFFFFF)
        .draw(ctx)

    let stops = arrival_1.route().getPlatforms().toArray().map((platform) => platform.stationName);
            let stops_at = ""
            let stationClean = pids.station().getName().normalize("NFC").trim();
            let i = stops.findIndex(s => s.normalize("NFC").trim() === stationClean) + 1;

            for (let x = 0; i < stops.length; i++) {
                stops_at += stops[i].replace("|", " ")
                if (i !== (stops.length - 1)) {
                    stops_at += ", "
                }
            }

            Text.create("text")
                .text("Calling at:")
                .pos(46, 26)
                .size(40, 6)
                .scaleXY()
                .scale(1)
                .color(0x000000)
                .draw(ctx);

            Text.create("arrival_first stops")
                .text(stops_at + ".")
                .pos(90, 25.5)
                .size(50, 6)
                .marquee()
                .scale(0.8)
                .color(0x000000)
                .draw(ctx);

    let car_length = arrival_1.carCount();
    Text.create("Arrival carCount")
        .text(car_length + " Coaches")
        .pos(65, 11)
        .scale(0.5)
        .color(0x000000)
        .draw(ctx);
    
    }
}

function dispose(ctx, state, pids) {
}