/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block;

import ivorius.psychedelicraft.block.entity.FlaskBlockEntity;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.screen.FluidContraptionScreenHandler;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public abstract class BlockWithFluid<T extends FlaskBlockEntity>
extends class_2237 {
    public static final class_2960 CONTENTS_DYNAMIC_DROP_ID = class_2960.method_43902((String)"minecraft", (String)"contents");

    protected BlockWithFluid(class_4970.class_2251 settings) {
        super(settings);
    }

    protected abstract class_2591<T> getBlockEntityType();

    protected abstract class_3917<FluidContraptionScreenHandler<T>> getScreenHandlerType();

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        if (!world.field_9236 && FluidCapacity.get(stack) > 0) {
            world.method_35230(pos, this.getBlockEntityType()).ifPresent(be -> be.getPrimaryTank().deposit(stack));
            ((class_3218)world).method_14178().method_14128(pos);
        }
    }

    @Deprecated
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        BlockWithFluid.appendDroppedStacks(this.method_8389().method_7854(), state, builder);
        return super.method_9560(state, builder);
    }

    @Deprecated
    public static void appendDroppedStacks(class_1799 defaultStack, class_2680 state, class_8567.class_8568 builder) {
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof DirectionalFluidResovoir) {
            DirectionalFluidResovoir container = (DirectionalFluidResovoir)blockEntity;
            builder = builder.method_51872(CONTENTS_DYNAMIC_DROP_ID, lootConsumer -> {
                List<class_1799> dynamicStacks = container.getDroppedStacks(defaultStack);
                if (dynamicStacks.isEmpty()) {
                    if (!defaultStack.method_7960()) {
                        lootConsumer.accept(defaultStack);
                    }
                } else {
                    dynamicStacks.forEach(stack -> lootConsumer.accept(stack));
                }
            });
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return world.method_35230(pos, this.getBlockEntityType()).map(be -> {
            class_1269 result = this.onInteract(be.method_11010(), world, be.method_11016(), player, hand, be);
            if (result != class_1269.field_5811) {
                return result;
            }
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){
                final /* synthetic */ FlaskBlockEntity val$be;
                final /* synthetic */ class_3965 val$hit;
                {
                    this.val$be = flaskBlockEntity;
                    this.val$hit = class_39652;
                }

                public class_2561 method_5476() {
                    return BlockWithFluid.this.method_9518();
                }

                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new FluidContraptionScreenHandler<FlaskBlockEntity>(BlockWithFluid.this.getScreenHandlerType(), syncId, inv, this.val$be, this.val$hit.method_17780());
                }

                public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                    new InteractionData(this.val$be.method_11016(), this.val$hit.method_17780()).write(buf);
                }
            });
            return class_1269.field_5812;
        }).orElse(class_1269.field_5814);
    }

    protected class_1269 onInteract(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, T blockEntity) {
        return class_1269.field_5811;
    }

    @Nullable
    public final <Q extends class_2586> class_5558<Q> method_31645(class_1937 world, class_2680 state, class_2591<Q> type) {
        return world.field_9236 ? BlockWithFluid.method_31618(type, this.getBlockEntityType(), (w, p, s, entity) -> entity.clientTick(w)) : BlockWithFluid.method_31618(type, this.getBlockEntityType(), (w, p, s, entity) -> entity.tick((class_3218)w));
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return this.getBlockEntityType().method_11032(pos, state);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return BlockWithFluid.toRedstoneSignal(world.method_35230(pos, this.getBlockEntityType()).map(FlaskBlockEntity::getPrimaryTank).map(tank -> Float.valueOf(class_3532.method_15363((float)((float)tank.getAmount() / (float)tank.getCapacity()), (float)0.0f, (float)1.0f))).orElse(Float.valueOf(0.0f)).floatValue(), 15);
    }

    static int toRedstoneSignal(float percentage, int maxSignal) {
        return percentage > 0.0f ? class_3532.method_15340((int)((int)(percentage * (float)maxSignal)), (int)1, (int)maxSignal) : 0;
    }

    public static interface DirectionalFluidResovoir
    extends SidedStorageBlockEntity,
    class_1278,
    Processable.Context {
        public List<class_1799> getDroppedStacks(class_1799 var1);

        public void tick(class_3218 var1);

        public void clientTick(class_1937 var1);

        default public Storage<FluidVariant> getFluidStorage(class_2350 side) {
            return this.getTankOnSide(side);
        }

        default public Storage<ItemVariant> getItemStorage(@Nullable class_2350 side) {
            return InventoryStorage.of((class_1263)this, (class_2350)side);
        }
    }

    public record InteractionData(class_2338 pos, class_2350 side) {
        public InteractionData(class_2540 buffer) {
            this(buffer.method_10811(), (class_2350)buffer.method_10818(class_2350.class));
        }

        public void write(class_2540 buffer) {
            buffer.method_10807(this.pos);
            buffer.method_10817((Enum)this.side);
        }
    }
}

