/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.render.FluidBoxRenderer;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.util.MathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2504;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_8923;
import net.minecraft.class_918;

public class PlacedDrinksModelProvider
implements PreparableModelLoadingPlugin<Map<String, Map<class_2960, Entry>>>,
PreparableModelLoadingPlugin.DataLoader<Map<String, Map<class_2960, Entry>>> {
    private static final class_2960 CONFIG_LOCATION = Psychedelicraft.id("placeable_drinks.json");
    private static final Gson GSON = new Gson();
    private static final class_5819 RNG = class_5819.method_43047();
    private static final long SEED = 42L;
    public static final PlacedDrinksModelProvider INSTANCE = new PlacedDrinksModelProvider();
    private static final Codec<Map<String, Map<class_2960, Entry>>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, Entry.MAP_CODEC);
    private Map<String, Map<class_2960, Entry>> entries = Map.of();

    public CompletableFuture<Map<String, Map<class_2960, Entry>>> load(class_3300 resourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> resourceManager.method_14486(CONFIG_LOCATION).map(resource -> {
            Map map;
            block8: {
                BufferedReader reader = resource.method_43039();
                try {
                    map = (Map)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class))).getOrThrow(false, s -> {})).getFirst();
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Psychedelicraft.LOGGER.error("Could not load client drinks file", (Throwable)e);
                        return null;
                    }
                }
                reader.close();
            }
            return map;
        }).orElseGet(Map::of), executor);
    }

    public void onInitializeModelLoader(Map<String, Map<class_2960, Entry>> data, ModelLoadingPlugin.Context context) {
        this.entries = data;
        data.forEach((type, entries) -> entries.forEach((id, entry) -> {
            context.addModels(new class_2960[]{PlacedDrinksModelProvider.getGroundModelId(type, id)});
            if (entry.showFluid()) {
                context.addModels(new class_2960[]{PlacedDrinksModelProvider.getGroundModelFluidId(type, id)});
            }
        }));
    }

    public Optional<Entry> get(String type, class_1792 item) {
        return Optional.ofNullable(this.entries.get(type).get(class_7923.field_41178.method_10221((Object)item)));
    }

    public void renderDrink(String type, class_1799 stack, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        int n;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1768) {
            class_1768 d = (class_1768)class_17922;
            n = d.method_7800(stack);
        } else {
            n = -1;
        }
        int dyeColor = n;
        this.renderDrinkModel(stack, matrices, vertices, light, overlay, dyeColor, PlacedDrinksModelProvider.getGroundModelId(type, stack.method_7909()));
        float fillPercentage = FluidCapacity.getPercentage(stack);
        Entry entry = this.get(type, stack.method_7909()).orElse(Entry.DEFAULT);
        if ((double)fillPercentage > 0.01 && entry.showFluid()) {
            float origin = entry.fluidOrigin() / 16.0f;
            matrices.method_46416(0.0f, origin, 0.0f);
            matrices.method_22905(1.0f, fillPercentage, 1.0f);
            matrices.method_46416(0.0f, -origin, 0.0f);
            int color = FluidBoxRenderer.FluidAppearance.getItemColor(ItemFluids.of(stack));
            this.renderDrinkModel(stack, matrices, vertices, light, overlay, color, PlacedDrinksModelProvider.getGroundModelFluidId(type, stack.method_7909()));
        }
    }

    public void renderDrinkModel(class_1799 stack, class_4587 matrices, class_4597 vertices, int light, int overlay, int color, class_2960 modelId) {
        class_1747 bi;
        class_918 renderer = class_310.method_1551().method_1480();
        class_1087 model = renderer.method_4012().method_3303().getModel(modelId);
        if (model == null) {
            Psychedelicraft.LOGGER.error("Model does not exist: " + String.valueOf(modelId));
            return;
        }
        class_1792 class_17922 = stack.method_7909();
        boolean solid = !(class_17922 instanceof class_1747) || !((bi = (class_1747)class_17922).method_7711() instanceof class_8923) && !(bi.method_7711() instanceof class_2504);
        class_1921 renderLayer = class_4696.method_23678((class_1799)stack, (boolean)solid);
        this.renderBakedItemModel(model, matrices, vertices.getBuffer(renderLayer), light, overlay, color);
    }

    private void renderBakedItemModel(class_1087 model, class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
        for (class_2350 direction : class_2350.values()) {
            RNG.method_43052(42L);
            this.renderBakedItemQuads(matrices, vertices, model.method_4707(null, direction, RNG), light, overlay, color);
        }
        RNG.method_43052(42L);
        this.renderBakedItemQuads(matrices, vertices, model.method_4707(null, null, RNG), light, overlay, color);
    }

    private void renderBakedItemQuads(class_4587 matrices, class_4588 vertices, List<class_777> quads, int light, int overlay, int color) {
        class_4587.class_4665 entry = matrices.method_23760();
        for (class_777 bakedQuad : quads) {
            vertices.method_22919(entry, bakedQuad, MathUtils.r(color), MathUtils.g(color), MathUtils.b(color), light, overlay);
        }
    }

    public static class_2960 getGroundModelId(String type, class_1792 item) {
        return PlacedDrinksModelProvider.getGroundModelId(type, class_7923.field_41178.method_10221((Object)item));
    }

    public static class_2960 getGroundModelFluidId(String type, class_1792 item) {
        return PlacedDrinksModelProvider.getGroundModelFluidId(type, class_7923.field_41178.method_10221((Object)item));
    }

    public static class_2960 getGroundModelId(String type, class_2960 item) {
        return item.method_45134(p -> "item/" + p + "_on_" + type);
    }

    public static class_2960 getGroundModelFluidId(String type, class_2960 item) {
        return PlacedDrinksModelProvider.getGroundModelId(type, item).method_48331("_fluid");
    }

    public record Entry(float height, float fluidOrigin, boolean showFluid) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("height").forGetter(Entry::height), (App)Codec.FLOAT.fieldOf("fluid_origin").forGetter(Entry::fluidOrigin), (App)Codec.BOOL.optionalFieldOf("show_fluid", (Object)false).forGetter(Entry::showFluid)).apply((Applicative)instance, Entry::new));
        public static final Codec<Map<class_2960, Entry>> MAP_CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, CODEC);
        public static final Entry DEFAULT = new Entry(0.5f, 0.0f, false);
    }
}

