/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.compat.tia;

import io.github.mattidragon.tlaapi.api.plugin.PluginContext;
import io.github.mattidragon.tlaapi.api.recipe.CategoryIcon;
import io.github.mattidragon.tlaapi.api.recipe.TlaCategory;
import io.github.mattidragon.tlaapi.api.recipe.TlaIngredient;
import io.github.mattidragon.tlaapi.api.recipe.TlaStack;
import ivorius.psychedelicraft.PSTags;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.compat.tia.DrawingFluidEmiRecipe;
import ivorius.psychedelicraft.compat.tia.DryingEmiRecipe;
import ivorius.psychedelicraft.compat.tia.FluidStagesEmiRecipe;
import ivorius.psychedelicraft.compat.tia.MashingEmiRecipe;
import ivorius.psychedelicraft.compat.tia.TrayEmiRecipe;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.recipe.PSRecipes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

record RecipeCategory(class_2960 id, CategoryIcon icon, TlaIngredient stations, int width, int height) implements TlaCategory
{
    static final Map<RecipeCategory, @Nullable BiConsumer<RecipeCategory, PluginContext>> REGISTRY = new HashMap<RecipeCategory, BiConsumer<RecipeCategory, PluginContext>>();
    public static final RecipeCategory DRYING_TABLE = RecipeCategory.register("drying_table", (class_1935)PSBlocks.DRYING_TABLE, 118, 74, (category, registry) -> registry.addRecipeGenerator(PSRecipes.DRYING_TYPE, DryingEmiRecipe::new));
    public static final RecipeCategory VAT = RecipeCategory.register("wooden_vat", (class_1935)PSBlocks.MASH_TUB, 130, 84, (category, registry) -> registry.addRecipeGenerator(PSRecipes.MASHING_TYPE, MashingEmiRecipe::new));
    public static final RecipeCategory BARREL = RecipeCategory.register("barrel", (class_1935)PSBlocks.OAK_BARREL, TlaIngredient.ofItemTag(PSTags.Items.BARRELS), 130, 70, DrawingFluidEmiRecipe.generate(648000));
    public static final RecipeCategory DISTILLERY = RecipeCategory.register("distillery", (class_1935)PSBlocks.DISTILLERY, 130, 70, DrawingFluidEmiRecipe.generate(648000));
    public static final RecipeCategory FLASK = RecipeCategory.register("flask", (class_1935)PSBlocks.FLASK, 130, 70, DrawingFluidEmiRecipe.generate(648000));
    public static final RecipeCategory TRAY = RecipeCategory.register("tray", (class_1935)PSBlocks.TRAY, 200, 70, (category, registry) -> registry.addRecipeGenerator(PSRecipes.TRAY, TrayEmiRecipe::new));
    public static final RecipeCategory PREPARATION = RecipeCategory.register("fluid_preparation", (class_1935)PSItems.BOTTLE, TlaIngredient.join((TlaIngredient[])new TlaIngredient[]{TlaIngredient.ofItemTag(PSTags.Items.BARRELS), TlaStack.of((class_1935)PSItems.DISTILLERY).asIngredient(), TlaStack.of((class_1935)PSItems.MASH_TUB).asIngredient(), TlaStack.of((class_1935)PSItems.BUNSEN_BURNER).asIngredient()}), 260, 20, FluidStagesEmiRecipe.generate());

    static RecipeCategory register(String name, class_1935 station, int width, int height, @Nullable BiConsumer<RecipeCategory, PluginContext> recipeConstructor) {
        return RecipeCategory.register(name, station, TlaIngredient.ofStacks((TlaStack[])new TlaStack[]{TlaStack.of((class_1935)station)}), width, height, recipeConstructor);
    }

    static RecipeCategory register(String name, class_1935 icon, TlaIngredient station, int width, int height, @Nullable BiConsumer<RecipeCategory, PluginContext> recipeConstructor) {
        class_2960 id = Psychedelicraft.id(name);
        return RecipeCategory.register(new RecipeCategory(id, CategoryIcon.item((class_1935)icon), station, width, height), recipeConstructor);
    }

    static RecipeCategory register(RecipeCategory category, @Nullable BiConsumer<RecipeCategory, PluginContext> recipeConstructor) {
        REGISTRY.put(category, recipeConstructor);
        return category;
    }

    static void bootstrap(PluginContext registry) {
        REGISTRY.forEach((category, recipeConstructor) -> {
            registry.addCategory((TlaCategory)category);
            registry.addWorkstation((TlaCategory)category, new TlaIngredient[]{category.stations()});
            try {
                if (recipeConstructor != null) {
                    recipeConstructor.accept(category, registry);
                }
            }
            catch (Throwable t) {
                Psychedelicraft.LOGGER.fatal("Error occured whilst registering recipes for category " + String.valueOf(category.getId()), t);
            }
        });
    }

    public class_2960 getId() {
        return this.id;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public CategoryIcon getIcon() {
        return this.icon;
    }

    public CategoryIcon getSimpleIcon() {
        return this.icon;
    }
}

