/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.compat.tia;

import io.github.mattidragon.tlaapi.api.recipe.TlaIngredient;
import io.github.mattidragon.tlaapi.api.recipe.TlaStack;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.recipe.ingredient.FluidIngredient;
import ivorius.psychedelicraft.util.compat.StackCompat;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_2096;
import net.minecraft.class_7923;

interface RecipeUtil {
    public static TlaStack toTlaStack(ItemFluids fluids) {
        return TlaStack.of((FluidVariant)fluids.toVariant(), (long)(fluids.amount() > 0 ? (long)Math.max(1, fluids.amount() / 1000) : 0L));
    }

    public static TlaStack toTlaStack(class_1799 receptical, ItemFluids fluids) {
        return TlaStack.of((class_1799)ItemFluids.set(receptical.method_7972(), fluids.ofAmount(FluidCapacity.get(receptical))));
    }

    public static TlaIngredient toFilled(TlaStack receptical, ItemFluids fluids) {
        return RecipeUtil.toTlaStack(((TlaStack.TlaItemStack)receptical).toStack(), fluids).asIngredient();
    }

    public static TlaIngredient toIngredient(class_1799 receptical, ItemFluids fluids) {
        return RecipeUtil.toTlaStack(receptical, fluids).asIngredient();
    }

    public static TlaIngredient toIngredient(FluidIngredient ingredient, int amount) {
        return RecipeUtil.toIngredient(ingredient.getAsItemFluid(amount));
    }

    public static TlaIngredient toIngredient(ItemFluids fluids) {
        return RecipeUtil.toTlaStack(fluids).asIngredient();
    }

    public static ItemFluids toItemFluids(TlaStack stack) {
        TlaStack.TlaItemStack it;
        Optional<ItemFluids> fluids;
        if (stack instanceof TlaStack.TlaFluidStack) {
            TlaStack.TlaFluidStack fl = (TlaStack.TlaFluidStack)stack;
            FluidVariant fluid = fl.getFluidVariant();
            return fluid.isBlank() ? ItemFluids.EMPTY : ItemFluids.of(fluid, Math.max(1, (int)stack.getAmount()));
        }
        if (stack instanceof TlaStack.TlaItemStack && (fluids = Optional.ofNullable(StackCompat.get((it = (TlaStack.TlaItemStack)stack).getItemVariant(), PSComponents.FLUIDS))) != null && fluids.isPresent()) {
            return fluids.get();
        }
        return ItemFluids.EMPTY;
    }

    public static List<ItemFluids> getMatchingFluids(ItemFluids.Predicate predicate, int amount) {
        List fluids = predicate.fluid().filter(l -> !l.isEmpty()).orElseGet(() -> class_7923.field_41173.method_10220().map(SimpleFluid::of).toList());
        if (predicate.amount().comp_1806().isPresent()) {
            amount = Math.min(amount, (Integer)predicate.amount().comp_1806().get());
        }
        if (predicate.amount().comp_1805().isPresent()) {
            amount = Math.max(amount, (Integer)predicate.amount().comp_1805().get());
        }
        int a = amount;
        return fluids.stream().map(fluid -> fluid.getDefaultStack(a)).toList();
    }

    public static IntStream stream(class_2096.class_2100 range) {
        int from = range.comp_1805().orElse(0);
        int to = range.comp_1806().orElse(16);
        return IntStream.range(from, to + 1);
    }

    public static Stream<TlaIngredient> grouped(Stream<TlaIngredient> ingredients) {
        HashMap counts = new HashMap();
        ingredients.forEach(ingredient -> counts.compute(ingredient, (key, count) -> count == null ? 1 : count + 1));
        return counts.entrySet().stream().map(entry -> ((TlaIngredient)entry.getKey()).withAmount((long)((Integer)entry.getValue()).intValue()));
    }

    public record Contents(ItemFluids type, TlaIngredient contents, TlaIngredient empty, TlaIngredient filled) {
        static Contents of(TlaIngredient recepticals, ItemFluids fluid) {
            return new Contents(fluid, RecipeUtil.toIngredient(fluid), TlaIngredient.join(recepticals.getStacks().stream().map(receptical -> RecipeUtil.toFilled(receptical, ItemFluids.EMPTY)).toList()), TlaIngredient.join(recepticals.getStacks().stream().map(receptical -> RecipeUtil.toFilled(receptical, fluid)).toList()));
        }
    }
}

