/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.hallucination;

import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.hallucination.EntityHallucination;
import ivorius.psychedelicraft.entity.drug.hallucination.EntityHallucinationList;
import ivorius.psychedelicraft.entity.drug.hallucination.EntityIdentitySwapHallucination;
import ivorius.psychedelicraft.entity.drug.hallucination.Hallucination;
import ivorius.psychedelicraft.entity.drug.hallucination.HallucinationTypeKeys;
import ivorius.psychedelicraft.entity.drug.hallucination.MultipleEntityHallucination;
import ivorius.psychedelicraft.entity.drug.hallucination.RastaHeadHallucination;
import ivorius.psychedelicraft.util.Pool;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public record EntityHallucinationType(class_2960 id, Function<class_1657, Hallucination> factory, float chance, class_2096.class_2099 strengthRange, @Nullable Predicate<EntityHallucinationList> condition) {
    public static final Map<class_2960, EntityHallucinationType> REGISTRY = new HashMap<class_2960, EntityHallucinationType>();

    public static Stream<EntityHallucinationType> getCandidates(EntityHallucinationList list) {
        class_5819 weight = list.getProperties().asEntity().method_6051();
        return REGISTRY.values().stream().filter(i -> i.strengthRange().method_9047((double)list.getManager().getEntityHallucinationStrength()) && weight.method_43057() <= i.chance() && (i.condition() == null || i.condition().test(list)));
    }

    static void register(class_2960 id, Function<class_1657, Hallucination> factory, float chance, class_2096.class_2099 strengthRange) {
        EntityHallucinationType.register(id, factory, chance, class_2096.class_2099.field_9705, null);
    }

    static void register(class_2960 id, Function<class_1657, Hallucination> factory, float chance, class_2096.class_2099 strengthRange, @Nullable Predicate<EntityHallucinationList> condition) {
        REGISTRY.put(id, new EntityHallucinationType(id, factory, chance, strengthRange, condition));
    }

    static {
        EntityHallucinationType.register(HallucinationTypeKeys.RASTA_HEAD, RastaHeadHallucination::new, 0.1f, class_2096.class_2099.field_9705, list -> list.getNumberOfHallucinations(a -> a instanceof RastaHeadHallucination) == 0 && list.getProperties().getDrugValue(DrugType.CANNABIS) > 0.4f);
        EntityHallucinationType.register(HallucinationTypeKeys.MULTIPLE_ENTITY, MultipleEntityHallucination::new, 0.5f, class_2096.class_2099.field_9705);
        EntityHallucinationType.register(HallucinationTypeKeys.SINGLE_ENTITY, EntityHallucination::new, 1.0f, class_2096.class_2099.field_9705);
        EntityHallucinationType.register(HallucinationTypeKeys.HOSTILE_VILLAGERS, player -> new EntityIdentitySwapHallucination((class_1657)player, (class_1299<?>)class_1299.field_6077, Pool.create(class_1299.field_6051, class_1299.field_6054)), 1.0f, class_2096.class_2099.method_9050((double)0.8f));
        EntityHallucinationType.register(HallucinationTypeKeys.FRIENDLY_ZOMBIES, player -> new EntityIdentitySwapHallucination((class_1657)player, (class_1299<?>)class_1299.field_6051, Pool.create(class_1299.field_6077)), 1.0f, class_2096.class_2099.method_9050((double)0.8f));
    }
}

