/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid.alcohol;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.fluid.AlcoholicFluid;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.alcohol.FluidAppearance;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.util.compat.ComponentType;
import ivorius.psychedelicraft.util.compat.ItemSubPredicate;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public record DrinkType(String drinkName, String symbolName, Optional<String> variant, Optional<DrugInfluence> extraDrug, FluidAppearance appearance) {
    public static final DrinkType ROOT = DrinkType.of("");
    public static final DrinkType TEA = DrinkType.of("tea").withAppearance(FluidAppearance.TEA);
    public static final DrinkType JUICE = DrinkType.of("juice");
    public static final DrinkType WORT = DrinkType.of("wort").withAppearance(FluidAppearance.BEER);
    public static final DrinkType VINEGAR = DrinkType.of("vinegar");
    public static final DrinkType BLAAND = DrinkType.of("blaand");
    public static final DrinkType ARKHI = DrinkType.of("arkhi");
    public static final DrinkType MEAD = DrinkType.of("mead").withAppearance(FluidAppearance.MEAD);
    public static final DrinkType WINE = DrinkType.of("wine").withAppearance(FluidAppearance.WINE);
    public static final DrinkType BRANDY = DrinkType.of("brandy").withAppearance(FluidAppearance.RUM_SEMI_MATURE);
    public static final DrinkType CIDER = DrinkType.of("cider").withAppearance(FluidAppearance.CIDER);
    public static final DrinkType POTEEN = DrinkType.of("poteen");
    public static final DrinkType GIN = DrinkType.of("gin");
    public static final DrinkType VODKA = DrinkType.of("vodka");
    public static final DrinkType WHISKEY = DrinkType.of("whiskey");
    public static final DrinkType KETCHUP = DrinkType.of("ketchup").withAppearance(FluidAppearance.KETCHUP);
    public static final DrinkType WASH = DrinkType.of("wash").withAppearance(FluidAppearance.RUM_MATURE);
    public static final DrinkType HALF_WASH = DrinkType.of("half_wash").withAppearance(FluidAppearance.RUM_SEMI_MATURE);
    public static final DrinkType BEER = DrinkType.of("beer").withAppearance(FluidAppearance.BEER);
    public static final DrinkType BASI = DrinkType.of("basi");
    public static final DrinkType RUM = DrinkType.of("rum").withAppearance(FluidAppearance.RUM_SEMI_MATURE);
    public static final DrinkType MEZCAL = DrinkType.of("mezcal").withAppearance(FluidAppearance.RUM_SEMI_MATURE);
    public static final DrinkType TEQUILA = DrinkType.of("tequila");

    public static DrinkType of(String drinkName) {
        return new DrinkType(drinkName, drinkName, Optional.empty(), Optional.empty(), FluidAppearance.CLEAR);
    }

    public static DrinkType of(String drinkName, DrinkType looksLike) {
        return new DrinkType(drinkName, looksLike.symbolName(), looksLike.variant(), looksLike.extraDrug(), looksLike.appearance());
    }

    public DrinkType withVariation(String variation) {
        return new DrinkType(this.drinkName, this.symbolName, Optional.of(variation), this.extraDrug, this.appearance);
    }

    public DrinkType withSymbol(String symbolName) {
        return new DrinkType(this.drinkName, symbolName, this.variant, this.extraDrug, this.appearance);
    }

    public DrinkType withName(String drinkName) {
        return new DrinkType(drinkName, this.symbolName, this.variant, this.extraDrug, this.appearance);
    }

    public DrinkType withAppearance(FluidAppearance appearance) {
        return new DrinkType(this.drinkName, this.symbolName, this.variant, this.extraDrug, appearance);
    }

    public DrinkType withExtraDrug(DrugInfluence extraDrug) {
        return new DrinkType(this.drinkName, this.symbolName, this.variant, Optional.of(extraDrug), this.appearance);
    }

    public String getUniqueKey() {
        return Stream.concat(Stream.of(this.appearance.name(), this.drinkName), this.variant.stream()).collect(Collectors.joining("_"));
    }

    public boolean isOf(DrinkType type) {
        return this.drinkName.equalsIgnoreCase(type.drinkName());
    }

    public class_2561 getName(class_2561 fluidName) {
        class_2561 name;
        Object object = name = this.drinkName.isEmpty() ? fluidName : class_2561.method_43469((String)("psychedelicraft.alcohol.drink." + this.drinkName), (Object[])new Object[]{fluidName});
        if (this.variant.isPresent()) {
            return class_2561.method_43469((String)("psychedelicraft.alcohol.drink.variant." + this.variant.get()), (Object[])new Object[]{name});
        }
        return name;
    }

    public class_2960 getSymbol(class_2960 fluidId) {
        return fluidId.method_45134(p -> "textures/fluid/" + this.symbolName + ".png");
    }

    public record Predicate(Optional<ItemFluids.Predicate> fluids, DrinkType name) implements ItemSubPredicate<ItemFluids>
    {
        public static final Codec<Predicate> CODEC = RecordCodecBuilder.create((T i) -> i.group((App)ItemFluids.Predicate.CODEC.optionalFieldOf("fluids").forGetter(Predicate::fluids), (App)Codec.STRING.xmap(DrinkType::of, DrinkType::drinkName).fieldOf("drink_name").forGetter(Predicate::name)).apply((Applicative)i, Predicate::new));

        public static Predicate create(DrinkType name) {
            return new Predicate(Optional.empty(), name);
        }

        public static Predicate create(DrinkType name, SimpleFluid ... fluid) {
            return new Predicate(Optional.of(ItemFluids.Predicate.builder().fluid(fluid).build()), name);
        }

        @Override
        public boolean test(class_1799 stack, ItemFluids fluids) {
            AlcoholicFluid alco;
            SimpleFluid simpleFluid;
            return (this.fluids.isEmpty() || this.fluids.get().test(stack, fluids)) && (simpleFluid = fluids.fluid()) instanceof AlcoholicFluid && (alco = (AlcoholicFluid)simpleFluid).getVariant(fluids).isOf(this.name);
        }

        @Override
        public ComponentType<ItemFluids> getComponentType() {
            return PSComponents.FLUIDS;
        }
    }

    public static interface Variation {
        public static final String YOUNG = "young";
        public static final String HARD = "hard";
        public static final String GREEN = "green";
        public static final String BITTER = "bitter";
        public static final String SWEET = "sweet";
        public static final String HALF_SWEET = "half_sweet";
        public static final String AGED = "aged";
        public static final String SLIGHTLY_AGED = "slightly_aged";
        public static final String WELL_AGED = "well_aged";
        public static final String BLANCO = "blanco";
        public static final String REPOSADO = "reposado";
        public static final String WINE = "wine";
    }
}

