/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid.container;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import org.jetbrains.annotations.UnmodifiableView;

public interface FluidTransferUtils {
    public static StandaloneContext standalone(class_1799 stack) {
        return new StandaloneContext(stack);
    }

    public static class_3545<class_1799, Optional<class_3545<Long, FluidVariant>>> extract(class_1799 stack, long amount) {
        StandaloneContext context = FluidTransferUtils.standalone(stack);
        Optional<class_3545> result = FluidTransferUtils.getAsContainer(stack, context).filter(c -> !c.isResourceBlank()).map(container -> FluidTransferUtils.applyTransaction(t -> {
            FluidVariant type = (FluidVariant)container.getResource();
            long amountExtracted = container.extract((Object)type, amount, (TransactionContext)t);
            if (amountExtracted > 0L) {
                return new class_3545((Object)amountExtracted, (Object)type);
            }
            return null;
        }));
        return new class_3545((Object)context.getStack(), result);
    }

    public static class_3545<class_1799, Long> deposit(class_1799 stack, FluidVariant variant, long amount) {
        StandaloneContext context = FluidTransferUtils.standalone(stack);
        long result = amount - FluidTransferUtils.getAsStorage(stack, context).map(storage -> FluidTransferUtils.applyTransaction(t -> storage.insert((Object)variant, amount, (TransactionContext)t))).orElse(0L);
        return new class_3545((Object)context.getStack(), (Object)result);
    }

    public static Optional<Storage<FluidVariant>> getAsStorage(class_1799 stack, ContainerItemContext context) {
        return Optional.ofNullable((Storage)FluidStorage.ITEM.find(stack, (Object)context));
    }

    private static Optional<StorageView<FluidVariant>> getAsContainer(class_1799 stack, ContainerItemContext context) {
        return FluidTransferUtils.getAsStorage(stack, context).map(storage -> {
            Iterator iter = storage.iterator();
            return iter.hasNext() ? (StorageView)iter.next() : null;
        });
    }

    public static Optional<class_3545<Long, FluidVariant>> getContents(class_1799 stack) {
        return FluidTransferUtils.getAsContainer(stack, ContainerItemContext.withConstant((class_1799)stack)).filter(c -> !c.isResourceBlank()).map(container -> new class_3545((Object)container.getAmount(), (Object)((FluidVariant)container.getResource())));
    }

    public static long getCapacity(class_1799 stack) {
        return FluidTransferUtils.getAsContainer(stack, ContainerItemContext.withConstant((class_1799)stack)).filter(c -> {
            if (c.isResourceBlank()) {
                // empty if block
            }
            return true;
        }).map(container -> container.getCapacity()).orElse(0L);
    }

    private static <T> T applyTransaction(Function<Transaction, T> action) {
        try (Transaction transaction = Transaction.isOpen() ? Transaction.getCurrentUnsafe().openNested() : Transaction.openOuter();){
            T t;
            try {
                t = action.apply(transaction);
            }
            catch (Throwable throwable) {
                transaction.commit();
                throw throwable;
            }
            transaction.commit();
            return t;
        }
    }

    public static final class StandaloneContext
    extends SingleStackStorage
    implements ContainerItemContext {
        private class_1799 stack;

        private StandaloneContext(class_1799 stack) {
            this.stack = stack;
        }

        public SingleSlotStorage<ItemVariant> getMainSlot() {
            return this;
        }

        public long insertOverflow(ItemVariant itemVariant, long maxAmount, TransactionContext transactionContext) {
            return 0L;
        }

        public @UnmodifiableView List<SingleSlotStorage<ItemVariant>> getAdditionalSlots() {
            return List.of();
        }

        public class_1799 getStack() {
            return this.stack;
        }

        protected void setStack(class_1799 stack) {
            this.stack = stack;
        }
    }
}

