/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.fluid.PSFluids;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.FluidMound;
import ivorius.psychedelicraft.recipe.ImpuritiesPredicate;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.recipe.ingredient.FluidIngredient;
import ivorius.psychedelicraft.util.PacketCodecUtils;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import ivorius.psychedelicraft.util.compat.RecipeInput;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6017;

public record HardeningRecipe(String hardeningGroup, FluidIngredient coreFluid, List<FluidIngredient> solutions, ImpuritiesPredicate impurities, class_1799 result, class_6017 amount, int hardeningTime) implements class_1860<Input>
{
    public static final MapCodec<HardeningRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.fieldOf("group").forGetter(HardeningRecipe::hardeningGroup), (App)FluidIngredient.CODEC.fieldOf("core_fluid").forGetter(HardeningRecipe::coreFluid), (App)FluidIngredient.CODEC.listOf().fieldOf("solutions").forGetter(HardeningRecipe::solutions), (App)ImpuritiesPredicate.CODEC.optionalFieldOf("impurities", (Object)ImpuritiesPredicate.EMPTY).forGetter(HardeningRecipe::impurities), (App)class_1799.field_24671.fieldOf("result").forGetter(HardeningRecipe::result), (App)class_6017.field_33451.fieldOf("amount").forGetter(HardeningRecipe::amount), (App)Codec.INT.optionalFieldOf("hardening_time", (Object)20).forGetter(HardeningRecipe::hardeningTime)).apply((Applicative)i, HardeningRecipe::new));
    public static final PacketCodec<class_2540, HardeningRecipe> PACKET_CODEC = PacketCodecUtils.tuple(PacketCodecs.STRING, HardeningRecipe::hardeningGroup, FluidIngredient.PACKET_CODEC, HardeningRecipe::coreFluid, FluidIngredient.PACKET_CODEC.collect(PacketCodecs.toList()), HardeningRecipe::solutions, ImpuritiesPredicate.PACKET_CODEC, HardeningRecipe::impurities, PacketCodecs.ITEM_STACK, HardeningRecipe::result, PacketCodecUtils.INT_PROVIDER_VALUE_CODEC, HardeningRecipe::amount, PacketCodecs.INTEGER, HardeningRecipe::hardeningTime, HardeningRecipe::new);

    public class_1799 method_17447() {
        return PSItems.TRAY.method_7854();
    }

    public class_1865<?> method_8119() {
        return PSRecipes.HARDENING;
    }

    public class_3956<?> method_17716() {
        return PSRecipes.TRAY;
    }

    public boolean matches(Input input, class_1937 world) {
        FluidMound fluids = FluidMound.of(input.impurities());
        return this.isCoreFluid(input.coreFluid()) && this.solutions.stream().allMatch(i -> fluids.removeMatch((FluidIngredient)i, -1) > 0) && this.impurities.test(input.cuts());
    }

    public boolean isCoreFluid(ItemFluids fluids) {
        return this.coreFluid.test(fluids);
    }

    public boolean isValidImpurity(ItemFluids fluids) {
        return this.solutions.stream().anyMatch(i -> i.test(fluids)) || fluids.isOf(PSFluids.PETROLIUM) || fluids.isOf(PSFluids.ETHANOL) || fluids.isOf(PSFluids.GASOLINE);
    }

    public String method_8112() {
        return this.hardeningGroup;
    }

    public class_1799 craft(Input input, class_5455 lookup) {
        class_1799 result = this.method_8110(lookup);
        FluidMound fluids = FluidMound.of(input.impurities());
        fluids.split(fluid -> this.solutions.stream().anyMatch(i -> i.test((ItemFluids)fluid)));
        Impurities inputCuts = this.impurities.permitted(input.cuts());
        int count = this.amount().method_35008(input.random()) * (int)Math.pow(2.0, inputCuts.impurities().size());
        return Impurities.set(result.method_46651(count), inputCuts);
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1799 method_8110(class_5455 lookup) {
        return this.result;
    }

    public boolean method_8118() {
        return true;
    }

    public boolean method_31584() {
        return this.coreFluid.isEmpty() && this.solutions.isEmpty();
    }

    public record Input(class_5819 random, ItemFluids coreFluid, FluidMound impurities, Impurities cuts) implements RecipeInput
    {
        @Override
        public class_1799 getStackInSlot(int slot) {
            return class_1799.field_8037;
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public boolean method_5442() {
            return this.coreFluid.isEmpty() && this.impurities.isEmpty();
        }
    }
}

