/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.world.gen;

import ivorius.psychedelicraft.PSTags;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.config.BiomeSelector;
import ivorius.psychedelicraft.config.FeatureCustomConfig;
import ivorius.psychedelicraft.config.Generation;
import ivorius.psychedelicraft.world.gen.PSFeatures;
import ivorius.psychedelicraft.world.gen.PSPlacedFeatures;
import ivorius.psychedelicraft.world.gen.TilledPatchFeature;
import ivorius.psychedelicraft.world.gen.loot.PSLootFunctionTypes;
import ivorius.psychedelicraft.world.gen.loot.PSLootTableEntryType;
import ivorius.psychedelicraft.world.gen.structure.MutableStructurePool;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7923;

public interface PSWorldGen {
    public static final TilledPatchFeature TILLED_PATCH = (TilledPatchFeature)((Object)class_2378.method_39197((class_2378)class_7923.field_41144, PSFeatures.TILLED_PATCH, (Object)((Object)new TilledPatchFeature())));

    public static void bootstrap() {
        Predicate<BiomeSelectionContext> patchSpawnValid = BiomeSelectors.foundInOverworld().and(BiomeSelector.COLD.or(BiomeSelectors.tag((class_6862)class_6908.field_36514)).or(BiomeSelectors.tag((class_6862)class_6908.field_36517)).or(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9451})));
        PSWorldGen.plant(PSPlacedFeatures.DENSE_JUNIPER_TREE, PSTags.Biomes.HAS_DENSE_JUNIPER_TREES, Generation::juniper);
        PSWorldGen.plant(PSPlacedFeatures.SPARCE_JUNIPER_TREE, PSTags.Biomes.HAS_SPARCE_JUNIPER_TREES, Generation::juniper);
        PSWorldGen.plant(PSPlacedFeatures.MORNING_GLORY_PATCH_CHECKED, PSTags.Biomes.HAS_MORNING_GLORY, Generation::morningGlories);
        PSWorldGen.plant(PSPlacedFeatures.BELLADONNA_PATCH_CHECKED, PSTags.Biomes.HAS_BELLADONNA, Generation::belladonna);
        PSWorldGen.plant(PSPlacedFeatures.JIMSONWEED_PATCH_CHECKED, PSTags.Biomes.HAS_JIMSONWEED, Generation::jimsonweed);
        PSWorldGen.plant(PSPlacedFeatures.TOMATO_PATCH_CHECKED, PSTags.Biomes.HAS_TOMATOES, Generation::tomato);
        PSWorldGen.plant(PSPlacedFeatures.PEYOTE_PATCH_CHECKED, PSTags.Biomes.HAS_PEYOTE, Generation::peyote);
        PSWorldGen.plant(PSPlacedFeatures.AGAVE_PATCH_CHECKED, PSTags.Biomes.HAS_PEYOTE, Generation::peyote);
        PSWorldGen.plant(PSPlacedFeatures.CANNABIS_TILLED_PATCH, patchSpawnValid, Generation::cannabis);
        PSWorldGen.plant(PSPlacedFeatures.HOP_TILLED_PATCH, patchSpawnValid, Generation::hop);
        PSWorldGen.plant(PSPlacedFeatures.TOBACCO_TILLED_PATCH, patchSpawnValid, Generation::tobacco);
        PSWorldGen.plant(PSPlacedFeatures.COFFEA_TILLED_PATCH, patchSpawnValid, Generation::coffea);
        PSWorldGen.plant(PSPlacedFeatures.COCA_TILLED_PATCH, patchSpawnValid, Generation::coca);
        MutableStructurePool.bootstrap();
        PSLootTableEntryType.bootstrap();
        PSLootFunctionTypes.bootstrap();
    }

    private static void plant(class_5321<class_6796> key, class_6862<class_1959> biomes, Function<Generation, FeatureCustomConfig> configKey) {
        PSWorldGen.plant(key, BiomeSelectors.tag(biomes), configKey);
    }

    private static void plant(class_5321<class_6796> key, Predicate<BiomeSelectionContext> predicate, Function<Generation, FeatureCustomConfig> configKey) {
        BiomeModifications.addFeature(context -> {
            FeatureCustomConfig config = (FeatureCustomConfig)configKey.apply((Generation)Psychedelicraft.getConfig().worldGeneration.get());
            return config.enabled() && config.spawnableBiomes().createPredicate(predicate).test((BiomeSelectionContext)context);
        }, (class_2893.class_2895)class_2893.class_2895.field_13178, key);
    }
}

