/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import ivorius.psychedelicraft.PSTags;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.block.BlockWithFluid;
import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.block.entity.SyncedBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_7225;
import net.minecraft.class_8567;

public class PlacedDrinksBlock
extends class_2237 {
    public static final MapCodec<PlacedDrinksBlock> CODEC = PlacedDrinksBlock.method_54094(PlacedDrinksBlock::new);
    private static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    protected PlacedDrinksBlock(class_4970.class_2251 settings) {
        super(settings.method_9634());
    }

    protected MapCodec<? extends PlacedDrinksBlock> method_53969() {
        return CODEC;
    }

    public boolean method_9538(class_2680 state) {
        return true;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return SHAPE;
    }

    protected boolean method_9526(class_2680 state) {
        return true;
    }

    protected float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return Psychedelicraft.getCrossHairTarget().filter(hit -> hit.method_17783() == class_239.class_240.field_1332).map(hit -> (class_3965)hit).filter(hit -> hit.method_17777().equals((Object)pos)).flatMap(Data::getHitPos).flatMap(hitPos -> world.method_35230(pos, PSBlockEntities.PLACED_DRINK).flatMap(be -> be.getDrink((class_2338)hitPos))).orElseGet(() -> super.method_9574(world, pos, state, includeData));
    }

    public static boolean canPlace(class_1799 stack) {
        return stack.method_31573(PSTags.Items.PLACEABLE_RECEPTICALS);
    }

    protected class_1269 method_55765(class_1799 heldStack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return world.method_35230(pos, PSBlockEntities.PLACED_DRINK).map(be -> {
            if (heldStack.method_7960()) {
                return Data.getHitPos(hit).flatMap(be::removeDrink).map(stack -> {
                    player.method_7270(stack);
                    return class_1269.field_5812;
                }).orElse((class_1269)class_1269.field_5814);
            }
            if (!PlacedDrinksBlock.canPlace(heldStack)) {
                return class_1269.field_5814;
            }
            return Data.getHitPos(hit).map(position -> be.placeDrink((class_2338)position, player.method_68878() ? heldStack.method_46651(1) : heldStack, player.method_5791())).orElse((class_1269)class_1269.field_5814);
        }).orElse((class_1269)class_1269.field_52423);
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        Object object = builder.method_51876(class_181.field_1228);
        if (object instanceof Data) {
            Data be = (Data)((Object)object);
            builder = builder.method_51872(BlockWithFluid.CONTENTS_DYNAMIC_DROP_ID, lootConsumer -> {
                be.forEachDrink((y, entry) -> {
                    lootConsumer.accept(entry.stack());
                    return 0.0f;
                });
                be.entries.clear();
            });
        }
        return super.method_9560(state, builder);
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
        if (!world.field_9236 && (entity.method_23318() > (double)pos.method_10264() || entity.method_23318() >= (double)pos.method_10264() && !entity.method_5715()) && entity instanceof class_1309 && Math.max(Math.abs(entity.method_23317() - entity.field_6038), Math.abs(entity.method_23321() - entity.field_5989)) >= (double)0.003f) {
            class_2248.method_9511((class_2680)state, (class_1937)world, (class_2338)pos, (class_2586)world.method_8321(pos), (class_1297)entity, (class_1799)class_1799.field_8037);
            world.method_8650(pos, false);
            world.method_45447(null, pos, class_3417.field_26958, class_3419.field_15245);
        }
    }

    protected void method_33614(class_1937 world, class_1657 player, class_2338 pos, class_2680 state) {
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new Data(pos, state);
    }

    public static class_1269 tryPlace(class_1838 context) {
        class_2338 blockPos;
        if (!PlacedDrinksBlock.canPlace(context.method_8041())) {
            return class_1269.field_5811;
        }
        class_2680 state = context.method_8045().method_8320(context.method_8037());
        boolean replaceable = state.method_26166(new class_1750(context));
        if (!replaceable && context.method_8038() != class_2350.field_11036) {
            return class_1269.field_5811;
        }
        if (state.method_27852(PSBlocks.PLACED_DRINK)) {
            return state.method_55780(context.method_8041(), context.method_8045(), context.method_8036(), context.method_20287(), new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), true)).method_23665() ? class_1269.field_5812 : class_1269.field_5811;
        }
        class_2338 class_23382 = blockPos = replaceable ? context.method_8037() : context.method_8037().method_10093(context.method_8038());
        if (!replaceable && !context.method_8045().method_22347(blockPos)) {
            return class_1269.field_5811;
        }
        class_2338 hitPos = Data.getHitPos(blockPos, context.method_17698());
        context.method_8045().method_8501(blockPos, PSBlocks.PLACED_DRINK.method_9564());
        return context.method_8045().method_35230(blockPos, PSBlockEntities.PLACED_DRINK).map(be -> be.placeDrink(hitPos, context.method_8041().method_7971(1), context.method_8044())).orElse((class_1269)class_1269.field_5814);
    }

    public static class Data
    extends SyncedBlockEntity {
        static final int MAX_COORD = 16;
        static final int MAX_INDEX = 256;
        static final int MAX_STACK_HEIGHT = 5;
        private final IntObjectMap<Stack<Entry>> entries = new IntObjectHashMap(256);

        public Data(class_2338 pos, class_2680 state) {
            super(PSBlockEntities.PLACED_DRINK, pos, state);
        }

        public void forEachDrink(DrinkConsumer consumer) {
            this.entries.values().forEach(list -> {
                float[] y = new float[1];
                list.forEach(drink -> {
                    y[0] = y[0] + consumer.accept(y[0], (Entry)drink);
                });
            });
        }

        public Optional<class_1799> removeDrink(class_2338 center) {
            return StreamSupport.stream(class_2338.method_30512((class_2338)center, (int)2, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11043).spliterator(), false).map(pos -> {
                Entry entry;
                int index = Data.getIndex((class_2338)pos);
                Stack list = (Stack)this.entries.get(index);
                if (list != null && (entry = (Entry)list.pop()) != null) {
                    if (list.isEmpty()) {
                        this.entries.remove(index);
                        if (this.entries.isEmpty()) {
                            this.method_10997().method_8650(this.method_11016(), false);
                        }
                    }
                    this.method_5431();
                    return entry.stack();
                }
                return class_1799.field_8037;
            }).filter(stack -> !stack.method_7960()).findFirst();
        }

        public boolean hasDrink(class_2338 center) {
            return StreamSupport.stream(class_2338.method_30512((class_2338)center, (int)2, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11043).spliterator(), false).map(pos -> (Stack)this.entries.get(Data.getIndex((class_2338)pos))).anyMatch(list -> list != null && !list.empty());
        }

        public Optional<class_1799> getDrink(class_2338 center) {
            return StreamSupport.stream(class_2338.method_30512((class_2338)center, (int)2, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11043).spliterator(), false).map(pos -> (Stack)this.entries.get(Data.getIndex((class_2338)pos))).filter(list -> list != null && !list.empty()).map(Stack::peek).map(Entry::stack).findFirst();
        }

        public class_1269 placeDrink(class_2338 position, class_1799 stack, float yaw) {
            int index = Data.getIndex(position);
            Stack<Entry> list = (Stack<Entry>)this.entries.get(index);
            if (list == null) {
                list = new Stack<Entry>();
                this.entries.put(index, list);
            }
            if (list.size() < 5) {
                list.add(new Entry((float)position.method_10263() / 16.0f - 0.5f, (float)position.method_10260() / 16.0f - 0.5f, -yaw % 360.0f, stack.method_7971(1)));
                this.method_10997().method_45447(null, this.method_11016(), class_3417.field_26958, class_3419.field_15245);
                this.method_5431();
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }

        public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
            this.readEntriesFromNbt(nbt.method_68568("entries"));
        }

        protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
            nbt.method_10566("entries", (class_2520)this.writeEntriesToNbt(new class_2487()));
        }

        private void readEntriesFromNbt(class_2487 nbt) {
            this.entries.clear();
            nbt.method_10541().forEach(key -> {
                int index = Integer.parseInt(key);
                nbt.method_67491(key, Entry.STACK_CODEC).ifPresent(s -> this.entries.put(index, s));
            });
        }

        private class_2487 writeEntriesToNbt(class_2487 nbt) {
            this.entries.entries().forEach(entry -> {
                if (!((Stack)entry.value()).isEmpty()) {
                    Entry.STACK_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)((Stack)entry.value())).result().ifPresent(stack -> nbt.method_10566("" + entry.key(), stack));
                }
            });
            return nbt;
        }

        public static Optional<class_2338> getHitPos(class_3965 hit) {
            class_2350 direction = hit.method_17780();
            if (direction.method_10166() != class_2350.class_2351.field_11052) {
                return Optional.empty();
            }
            return Optional.of(Data.getHitPos(hit.method_17777().method_10093(direction), hit.method_17784()));
        }

        public static class_2338 getHitPos(class_2338 pos, class_243 relativePos) {
            return class_2338.method_49637((double)((relativePos.method_10216() - (double)pos.method_10263()) * 16.0), (double)0.0, (double)((relativePos.method_10215() - (double)pos.method_10260()) * 16.0));
        }

        private static int getIndex(class_2338 position) {
            return (Math.max(0, position.method_10263()) * 16 + Math.max(0, position.method_10260())) % 256;
        }

        public static interface DrinkConsumer {
            public float accept(float var1, Entry var2);
        }

        public record Entry(float x, float z, float rotation, class_1799 stack) {
            static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("x").forGetter(Entry::x), (App)Codec.FLOAT.fieldOf("z").forGetter(Entry::z), (App)Codec.FLOAT.fieldOf("rotation").forGetter(Entry::rotation), (App)class_1799.field_24671.fieldOf("stack").forGetter(Entry::stack)).apply((Applicative)instance, Entry::new));
            static final Codec<Stack<Entry>> STACK_CODEC = CODEC.listOf().xmap(list -> list.stream().collect(Collectors.toCollection(Stack::new)), stack -> List.copyOf(stack));
        }
    }
}

