/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block.entity;

import com.mojang.datafixers.util.Either;
import ivorius.psychedelicraft.PSSounds;
import ivorius.psychedelicraft.block.BlockWithFluid;
import ivorius.psychedelicraft.block.BurnerBlock;
import ivorius.psychedelicraft.block.PipeInsertable;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.block.entity.SyncedBlockEntity;
import ivorius.psychedelicraft.block.entity.contents.EmptyContents;
import ivorius.psychedelicraft.block.entity.contents.LargeContents;
import ivorius.psychedelicraft.block.entity.contents.SmallContents;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.particle.DrugDustParticleEffect;
import ivorius.psychedelicraft.particle.PSParticles;
import ivorius.psychedelicraft.recipe.BunsenBurnerRecipe;
import ivorius.psychedelicraft.recipe.FluidMound;
import ivorius.psychedelicraft.recipe.ItemMound;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.util.NbtSerialisable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3902;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class BurnerBlockEntity
extends SyncedBlockEntity
implements BlockWithFluid.DirectionalFluidResovoir,
PipeInsertable {
    static final int[] CONTAINER_SLOT_ID = new int[]{0};
    private int temperature;
    private class_1799 container = class_1799.field_8037;
    private Contents contents = new EmptyContents(this);
    @Nullable
    private BunsenBurnerRecipe.Product product;
    private int processingTime;

    public BurnerBlockEntity(class_2338 pos, class_2680 state) {
        super(PSBlockEntities.BUNSEN_BURNER, pos, state);
    }

    public void setContainer(class_1799 container) {
        this.container = container.method_7972();
        this.container.method_57381(PSComponents.FLUIDS);
        this.container.method_57381(PSComponents.FLUIDS_MIXTURE);
        this.container.method_57381(PSComponents.RIFT_FRACTION);
        this.processingTime = 0;
        this.method_5431();
    }

    public class_1799 getContainer() {
        return this.container;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
        this.method_5431();
    }

    public Contents getContents() {
        return this.contents;
    }

    public boolean interact(class_1799 stack, class_1657 player, class_1268 hand, class_2350 side) {
        if (hand != class_1268.field_5808) {
            return false;
        }
        boolean accepted = this.contents.interact(stack, player, hand, side).filter(c -> {
            this.contents = c;
            return true;
        }).isPresent();
        this.method_5431();
        return accepted;
    }

    public void playSound(@Nullable class_1657 player, class_3414 sound) {
        if (this.field_11863 != null && this.field_11867 != null) {
            this.field_11863.method_8396((class_1297)player, this.field_11867.method_10084(), sound, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.4f + 0.8f);
        }
    }

    @Override
    public void clientTick(class_1937 world) {
        if (this.getTemperature() > 60 && this.getTotalFluidVolume() > 0) {
            class_2338 pos = this.method_11016();
            world.method_8406((class_2394)new DrugDustParticleEffect(PSParticles.BUBBLE, -1, 0.6f), world.method_8409().method_43385((double)pos.method_10263() + 0.5, 0.2), world.method_8409().method_43385((double)(pos.method_10264() + 1), 0.2), world.method_8409().method_43385((double)pos.method_10260() + 0.5, 0.2), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void tick(class_3218 world) {
        if (world.method_8510() % 14L == 0L) {
            if (((Boolean)this.method_11010().method_11654((class_2769)BurnerBlock.LIT)).booleanValue()) {
                if (this.temperature < (this.getPrimaryTank().getContents().isEmpty() ? 200 : 100)) {
                    ++this.temperature;
                    this.method_5431();
                }
            } else if (this.temperature > 0) {
                --this.temperature;
                this.method_5431();
            }
        }
        this.contents.tick(world);
        Contents contents = this.contents;
        if (contents instanceof CraftableContents) {
            CraftableContents c = (CraftableContents)contents;
            if (this.product != null && !this.product.fluids().isEmpty()) {
                if (world.method_8510() % 5L == 0L) {
                    world.method_8396(null, this.method_11016(), PSSounds.BLOCK_BUNSEN_BURNER_WORK, class_3419.field_15245, 1.25f, 0.02f);
                    world.method_33596(null, (class_6880)class_5712.field_28733, this.field_11867);
                    c.produceProducts(world, this.method_11016().method_10084(), this.product);
                    if (c.getPrimaryTank().getContents().isEmpty()) {
                        this.product = null;
                    }
                    if (this.temperature > 90) {
                        this.setTemperature(this.temperature - 1);
                    }
                }
                return;
            }
            if (this.temperature <= 50 || world.method_8510() % 5L != (long)world.field_9229.method_43048(3)) {
                return;
            }
            if (this.getTotalFluidVolume() == 0) {
                class_2338 pos = this.method_11016();
                world.method_8396(null, pos, PSSounds.BLOCK_BUNSEN_BURNER_OVERHEAT, class_3419.field_15245, 1.25f, 0.02f);
                world.method_65096((class_2394)class_2398.field_11251, (double)((float)pos.method_10263() + world.method_8409().method_62816(0.5f, 0.1f)), (double)((float)pos.method_10264() + 0.6f), (double)((float)pos.method_10260() + world.method_8409().method_62816(0.5f, 0.1f)), 2, 0.0, 0.0, 0.0, 0.0);
                if (this.temperature > 180 && world.field_9229.method_43048(3) == 0) {
                    world.method_8396(null, pos, class_3417.field_15081, class_3419.field_15245, 1.25f, 0.02f);
                    world.method_20290(2001, pos, class_2248.method_9507((class_2680)class_2246.field_10285.method_9564()));
                    world.method_33596(null, (class_6880)class_5712.field_28165, pos);
                    class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)PSItems.BROKEN_GLASS, world.field_9229.method_39332(1, 3)));
                    class_243 center = pos.method_46558();
                    for (class_1309 entity : world.method_8390(class_1309.class, class_238.method_30048((class_243)center, (double)2.0, (double)2.0, (double)2.0), class_1301.field_6156)) {
                        entity.method_64397(world, world.method_48963().method_48819(null, null), 3.0f);
                        entity.method_6005(0.1, center.field_1352 - entity.method_23317(), center.field_1350 - entity.method_23321());
                    }
                    this.method_5448();
                }
            } else {
                if (this.getTemperature() > 100) {
                    this.temperature -= 2;
                    this.setTemperature(this.temperature);
                }
                world.method_8396(null, this.method_11016(), PSSounds.BLOCK_BUNSEN_BURNER_WORK, class_3419.field_15245, 1.25f, 0.02f);
                world.method_33596(null, (class_6880)class_5712.field_28733, this.field_11867);
                this.product = this.craft(world, c);
            }
        } else {
            this.processingTime = 0;
            this.product = null;
        }
    }

    private BunsenBurnerRecipe.Product craft(class_3218 world, CraftableContents contents) {
        BunsenBurnerRecipe.Product consumer = new BunsenBurnerRecipe.Product(FluidMound.of(), new ArrayList<class_1799>(), new HashSet<Impurities.Impurity>());
        BunsenBurnerRecipe.Input input = new BunsenBurnerRecipe.Input(FluidMound.of(this), contents.getCraftingIngredients(), consumer);
        world.method_64577().method_8132(PSRecipes.CHEMISTRY, (class_9695)input, (class_1937)world).ifPresentOrElse(recipe -> {
            if (++this.processingTime >= ((BunsenBurnerRecipe)recipe.comp_1933()).stewTime()) {
                this.processingTime = 0;
                this.craftAndCollectResult(world, input, (class_8786<BunsenBurnerRecipe>)recipe);
                contents.onCraft(input);
            }
        }, () -> this.getAuxiliaryTanks().forEach(tank -> {
            Processable.ProcessType type;
            Processable processable;
            SimpleFluid patt0$temp = tank.getContents().fluid();
            if (patt0$temp instanceof Processable && (processable = (Processable)((Object)patt0$temp)).getProcessingTime((Resovoir)tank, type = processable.modifyProcess((Resovoir)tank, Processable.ProcessType.PURIFY)) != -1) {
                processable.process(contents, type, consumer);
                return;
            }
            consumer.accept(tank.drain(Math.max(1, (int)tank.getAmount() / 10)));
        }));
        return consumer;
    }

    private void craftAndCollectResult(class_3218 world, BunsenBurnerRecipe.Input input, class_8786<BunsenBurnerRecipe> recipe) {
        class_1799 byProduct = ((BunsenBurnerRecipe)recipe.comp_1933()).method_8116(input, (class_7225.class_7874)world.method_30349());
        if (!byProduct.method_7960()) {
            input.consumer().accept(byProduct);
        }
        if (input.nextPhase() != null) {
            world.method_64577().getAllMatches(PSRecipes.CHEMISTRY, (class_9695)input.nextPhase(), (class_1937)world).forEach(addition -> this.craftAndCollectResult(world, input.nextPhase(), (class_8786<BunsenBurnerRecipe>)addition));
        }
    }

    @Override
    public Resovoir getPrimaryTank() {
        Resovoir resovoir;
        Contents contents = this.contents;
        if (contents instanceof Processable.Context) {
            Processable.Context c = (Processable.Context)((Object)contents);
            resovoir = c.getPrimaryTank();
        } else {
            resovoir = Resovoir.EMPTY;
        }
        return resovoir;
    }

    @Override
    public Resovoir getTankOnSide(class_2350 direction) {
        Resovoir resovoir;
        Contents contents = this.contents;
        if (contents instanceof Processable.Context) {
            Processable.Context c = (Processable.Context)((Object)contents);
            resovoir = c.getTankOnSide(direction);
        } else {
            resovoir = Resovoir.EMPTY;
        }
        return resovoir;
    }

    @Override
    public List<Resovoir> getAuxiliaryTanks() {
        List<Resovoir> list;
        Contents contents = this.contents;
        if (contents instanceof Processable.Context) {
            Processable.Context c = (Processable.Context)((Object)contents);
            list = c.getAuxiliaryTanks();
        } else {
            list = List.of();
        }
        return list;
    }

    public void method_5448() {
        Object object = this.contents;
        if (object instanceof CraftableContents) {
            CraftableContents c = (CraftableContents)object;
            object = this.method_10997();
            if (object instanceof class_3218) {
                class_3218 sw = (class_3218)object;
                for (class_1799 stack : c.getCraftingIngredients().convertToItemStacks()) {
                    class_2248.method_9577((class_1937)sw, (class_2338)this.method_11016(), (class_1799)stack);
                }
            }
        }
        this.contents = new EmptyContents(this);
        this.container = class_1799.field_8037;
        this.processingTime = 0;
        this.method_5431();
    }

    @Override
    public boolean acceptsConnectionFrom(class_4538 world, class_2680 state, class_2338 pos, class_2680 neighborState, class_2338 neighborPos, class_2350 direction, boolean input) {
        return input && direction == class_2350.field_11036;
    }

    @Override
    public Either<PipeInsertable.PipeFluids, class_3902> tryInsert(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction, PipeInsertable.PipeFluids fluids) {
        if (direction != class_2350.field_11033) {
            return PipeInsertable.reject(fluids);
        }
        return this.getContents().tryInsert(world, state, pos, direction, fluids);
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 lookup) {
        super.method_11007(compound, lookup);
        compound.method_10569("temperature", this.temperature);
        compound.method_10569("processingTime", this.processingTime);
        compound.method_67494("container", class_1799.field_49266, (Object)this.container);
        compound.method_68082("product", BunsenBurnerRecipe.Product.CODEC, (Object)this.product);
        compound.method_10582("contentsType", this.contents.getId().toString());
        compound.method_10566("contents", (class_2520)this.contents.toNbt(lookup));
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 lookup) {
        super.method_11014(compound, lookup);
        this.temperature = compound.method_68083("temperature", 0);
        this.processingTime = compound.method_68083("processingTime", 0);
        this.product = compound.method_67491("product", BunsenBurnerRecipe.Product.CODEC).orElse(null);
        this.container = compound.method_67491("container", class_1799.field_49266).orElse(class_1799.field_8037);
        class_2960 contentType = compound.method_10558("contentsType").map(class_2960::method_60654).orElse(EmptyContents.ID);
        if (contentType.equals((Object)this.contents.getId())) {
            this.contents.fromNbt(compound.method_68568("contents"), lookup);
        } else {
            this.contents = Contents.TYPES.getOrDefault(contentType, Contents.TYPES.get(EmptyContents.ID)).create(this, compound.method_68568("contents"), lookup);
        }
    }

    public int[] method_5494(class_2350 side) {
        int[] nArray;
        if (side.method_10166() == class_2350.class_2351.field_11052) {
            nArray = CONTAINER_SLOT_ID;
        } else {
            Contents contents = this.contents;
            if (contents instanceof class_1278) {
                class_1278 l = (class_1278)contents;
                nArray = l.method_5494(side);
            } else {
                nArray = new int[]{};
            }
        }
        return nArray;
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        class_1278 l;
        if (slot == CONTAINER_SLOT_ID[0] && dir == class_2350.field_11036) {
            return this.container.method_7960() && FluidCapacity.get(stack) > 0;
        }
        Contents contents = this.contents;
        return contents instanceof class_1278 && (l = (class_1278)contents).method_5492(slot - 1, stack, dir);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        class_1278 l;
        if (slot == CONTAINER_SLOT_ID[0] && this.container.method_7960()) {
            return false;
        }
        Contents contents = this.contents;
        return contents instanceof class_1278 && (l = (class_1278)contents).method_5493(slot - 1, stack, dir);
    }

    public int method_5439() {
        int n;
        Contents contents = this.contents;
        if (contents instanceof class_1263) {
            class_1263 i = (class_1263)contents;
            n = i.method_5439();
        } else {
            n = 0;
        }
        return 1 + n;
    }

    public boolean method_5442() {
        return this.container.method_7960() && this.contents.method_5442();
    }

    public class_1799 method_5438(int slot) {
        class_1799 class_17992;
        if (slot == 0) {
            return this.contents.getFilled(this.container, true, 1.0f);
        }
        Contents contents = this.contents;
        if (contents instanceof class_1263) {
            class_1263 l = (class_1263)contents;
            class_17992 = l.method_5438(slot - 1);
        } else {
            class_17992 = class_1799.field_8037;
        }
        return class_17992;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 class_17992;
        if (slot == 0) {
            float drainPercentage = (float)this.container.method_7947() / (float)amount;
            return this.contents.getFilled(this.container.method_7971(amount), false, drainPercentage);
        }
        Contents contents = this.contents;
        if (contents instanceof class_1263) {
            class_1263 l = (class_1263)contents;
            class_17992 = l.method_5434(slot - 1, amount);
        } else {
            class_17992 = class_1799.field_8037;
        }
        return class_17992;
    }

    public class_1799 method_5441(int slot) {
        class_1799 class_17992;
        if (slot == 0) {
            return this.contents.getFilled(this.container.method_51164(), false, 1.0f);
        }
        Contents contents = this.contents;
        if (contents instanceof class_1263) {
            class_1263 l = (class_1263)contents;
            class_17992 = l.method_5441(slot - 1);
        } else {
            class_17992 = class_1799.field_8037;
        }
        return class_17992;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot == 0) {
            this.container = stack.method_7971(1);
            this.contents = new EmptyContents(this).getForStack(this.method_10997(), this.method_11016(), this.method_11010(), stack);
        } else {
            Contents contents = this.contents;
            if (contents instanceof class_1263) {
                class_1263 l = (class_1263)contents;
                l.method_5447(slot - 1, stack);
            }
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Override
    @Deprecated
    public List<class_1799> getDroppedStacks(class_1799 ignored) {
        Contents contents = this.contents;
        if (contents instanceof BlockWithFluid.DirectionalFluidResovoir) {
            BlockWithFluid.DirectionalFluidResovoir l = (BlockWithFluid.DirectionalFluidResovoir)((Object)contents);
            return l.getDroppedStacks(this.getContainer());
        }
        if (!this.getContainer().method_7960()) {
            return List.of(this.method_5441(0));
        }
        return List.of();
    }

    public static interface Contents
    extends NbtSerialisable,
    PipeInsertable {
        public static final Map<class_2960, Factory> TYPES = (Map)class_156.method_654(new HashMap(), map -> {
            map.put(EmptyContents.ID, (entity, nbt, lookup) -> new EmptyContents(entity));
            map.put(SmallContents.ID, (entity, nbt, lookup) -> {
                SmallContents contents = new SmallContents(entity, 0, class_1799.field_8037);
                contents.fromNbt(nbt, lookup);
                return contents;
            });
            map.put(LargeContents.ID, (entity, nbt, lookup) -> {
                LargeContents contents = new LargeContents(entity, 0, class_1799.field_8037);
                ((SmallContents)contents).fromNbt(nbt, lookup);
                return contents;
            });
        });

        public class_2960 getId();

        public void tick(class_3218 var1);

        public boolean method_5442();

        public class_1799 getFilled(class_1799 var1, boolean var2, float var3);

        public Optional<Contents> interact(class_1799 var1, class_1657 var2, class_1268 var3, class_2350 var4);

        public class_265 getOutlineShape();

        public static interface Factory {
            public Contents create(BurnerBlockEntity var1, class_2487 var2, class_7225.class_7874 var3);
        }
    }

    public static interface CraftableContents
    extends Contents,
    Processable.Context {
        public ItemMound getCraftingIngredients();

        public void produceProducts(class_3218 var1, class_2338 var2, BunsenBurnerRecipe.Product var3);

        public void onCraft(BunsenBurnerRecipe.Input var1);
    }
}

