/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block.entity;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import ivorius.psychedelicraft.ParticleHelper;
import ivorius.psychedelicraft.block.MashTubBlock;
import ivorius.psychedelicraft.block.PipeInsertable;
import ivorius.psychedelicraft.block.entity.FluidProcessingBlockEntity;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.fluid.PSFluids;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.particle.DrugDustParticleEffect;
import ivorius.psychedelicraft.particle.PSParticles;
import ivorius.psychedelicraft.recipe.ItemMound;
import ivorius.psychedelicraft.recipe.MashingRecipe;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.util.NbtSerialisable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1269;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class MashTubBlockEntity
extends FluidProcessingBlockEntity {
    public class_1799 solidContents = class_1799.field_8037;
    private ItemFluids auxiliaryFluids = ItemFluids.EMPTY;
    private Optional<Stew> currentStew = Optional.empty();
    private final ItemMound suppliedIngredients = new ItemMound();

    public MashTubBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends FluidProcessingBlockEntity>)PSBlockEntities.MASH_TUB, pos, state, 729000);
    }

    public ItemMound getSuppliedIngredients() {
        return this.suppliedIngredients;
    }

    public ItemFluids getAuxiliaryFluids() {
        return this.auxiliaryFluids;
    }

    @Override
    public void accept(class_1799 stack) {
        if (this.field_11863 == null) {
            return;
        }
        if (!this.solidContents.method_7960()) {
            int maxToMove;
            if (class_1799.method_31577((class_1799)this.solidContents, (class_1799)stack) && (maxToMove = Math.min(stack.method_7947(), this.solidContents.method_7914() - this.solidContents.method_7947())) > 0) {
                stack.method_7934(maxToMove);
                this.solidContents.method_7933(maxToMove);
                this.field_11863.method_45447(null, this.field_11867, class_3417.field_17609, class_3419.field_15245);
                return;
            }
            class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)this.solidContents);
            this.field_11863.method_45447(null, this.field_11867, class_3417.field_15197, class_3419.field_15245);
        }
        this.solidContents = stack;
        this.field_11863.method_45447(null, this.field_11867, class_3417.field_17609, class_3419.field_15245);
    }

    @Override
    protected void onFluidRejected(class_3218 world, ItemFluids fluids) {
        if (this.auxiliaryFluids.isEmpty()) {
            this.auxiliaryFluids = fluids;
        } else {
            if (this.auxiliaryFluids.canCombine(fluids)) {
                int spaceInTank = (int)(this.getPrimaryTank().getCapacity() - this.getPrimaryTank().getAmount());
                int maxInserted = Math.min(fluids.amount(), spaceInTank - this.auxiliaryFluids.amount());
                if (maxInserted > 0) {
                    this.auxiliaryFluids = this.auxiliaryFluids.ofAmount(this.auxiliaryFluids.amount() + maxInserted);
                    if (maxInserted >= fluids.amount()) {
                        return;
                    }
                    fluids = fluids.ofAmount(fluids.amount() - maxInserted);
                }
            }
            super.onFluidRejected(world, fluids);
        }
    }

    @Override
    public Processable.ProcessType getProcessType() {
        return Processable.ProcessType.FERMENT;
    }

    @Override
    public void tick(class_3218 world) {
        if (this.isAcceptingIngredients()) {
            class_243 center = this.method_11016().method_46558();
            class_238 box = class_238.method_30048((class_243)center, (double)1.5, (double)0.5, (double)1.5);
            for (class_1542 item : world.method_8390(class_1542.class, box, class_1301.field_6154)) {
                class_1799 stack = item.method_6983();
                if (!this.isValidIngredient(world, stack)) continue;
                this.suppliedIngredients.addStack(stack);
                this.beginStewing(world);
                this.markForUpdate();
                this.spawnBubbles(20, 0.0f, class_3417.field_15065);
                this.method_10997().method_8396(null, this.method_11016(), class_3417.field_14737, class_3419.field_15245, 1.0f, 1.0f);
                item.method_31472();
            }
        }
        if (this.currentStew.isEmpty()) {
            super.tick(world);
        }
        this.currentStew = this.currentStew.filter(stew -> stew.tick(world));
    }

    @Override
    public void onLevelChange(Resovoir resovoir, int difference) {
        if (this.field_11863 == null) {
            return;
        }
        if (resovoir.getContents().isEmpty() && !this.auxiliaryFluids.isEmpty()) {
            resovoir.setContents(this.auxiliaryFluids, false);
            this.auxiliaryFluids = ItemFluids.EMPTY;
        }
        super.onLevelChange(resovoir, difference);
        int luminance = resovoir.getContents().fluid().getPhysical().getDefaultState().method_15759().method_26213();
        int currentLuminance = (Integer)this.method_11010().method_11654((class_2769)MashTubBlock.LIGHT);
        if (luminance != currentLuminance) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)MashTubBlock.LIGHT, (Comparable)Integer.valueOf(luminance)));
        }
        if (difference > 0) {
            this.setTimeProcessed(0);
            this.setRepeatCount(0);
        }
        if (resovoir.getContents().isEmpty() && !this.suppliedIngredients.isEmpty()) {
            for (class_1799 stack : this.suppliedIngredients.convertToItemStacks()) {
                class_2248.method_9577((class_1937)this.method_10997(), (class_2338)this.method_11016(), (class_1799)stack);
            }
            this.field_11863.method_45447(null, this.field_11867, class_3417.field_15197, class_3419.field_15245);
            this.suppliedIngredients.clear();
        }
    }

    @Override
    public void clientTick(class_1937 world) {
        super.clientTick(world);
        if (!this.suppliedIngredients.isEmpty() && world.method_8409().method_43057() < 0.33f && world.method_8510() % 3L == 0L) {
            this.spawnBubbles(1 + (int)((double)this.suppliedIngredients.size() * 1.5), 0.0f, class_3417.field_15065);
        }
    }

    public Either<class_1799, class_1269> interactWithItem(class_1799 stack, class_1657 player) {
        if (!this.currentStew.isEmpty()) {
            return Either.right((Object)class_1269.field_5814);
        }
        if (this.method_10997().field_9236) {
            return Either.right((Object)class_1269.field_5812);
        }
        if (FluidCapacity.get(stack) > 0) {
            ItemFluids.Transaction t = ItemFluids.Transaction.begin(stack.method_7972());
            Resovoir tank = this.getPrimaryTank();
            FluidVariant variant = t.fluids().toVariant();
            if (!t.fluids().isEmpty()) {
                if (tank.deposit(t, t.capacity()) > 0) {
                    this.method_10997().method_8396(null, this.method_11016(), FluidVariantAttributes.getEmptySound((FluidVariant)variant), class_3419.field_15245, 1.0f, 1.0f);
                    return Either.left((Object)t.toItemStack());
                }
            } else if (tank.withdraw(t, t.capacity()) > 0) {
                this.method_10997().method_8396(null, this.method_11016(), FluidVariantAttributes.getFillSound((FluidVariant)variant), class_3419.field_15245, 1.0f, 1.0f);
                return Either.left((Object)t.toItemStack());
            }
            return Either.right((Object)class_1269.field_5814);
        }
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            if (this.isAcceptingIngredients() && this.acceptsItem(stack)) {
                this.suppliedIngredients.addStack(stack.method_60504(1, (class_1309)player));
                this.beginStewing(sw);
                this.markForUpdate();
                this.spawnBubbles(20, 0.0f, class_3417.field_15065);
                this.method_10997().method_8396(null, this.method_11016(), class_3417.field_14737, class_3419.field_15245, 1.0f, 1.0f);
                return Either.right((Object)class_1269.field_52422);
            }
        }
        return Either.right((Object)class_1269.field_52423);
    }

    public boolean acceptsItem(class_1799 stack) {
        return FluidCapacity.get(stack) == 0;
    }

    public boolean isAcceptingIngredients() {
        return this.currentStew.isEmpty() && !this.getPrimaryTank().getContents().isEmpty();
    }

    public boolean isValidIngredient(class_3218 world, class_1799 stack) {
        return this.acceptsItem(stack) && world.method_64577().getAllOfType(PSRecipes.MASHING_TYPE).stream().anyMatch(recipe -> ((MashingRecipe)recipe.comp_1933()).isAcceptableIngredient(this.getPrimaryTank().getContents(), stack));
    }

    public void beginStewing(class_3218 world) {
        if (this.suppliedIngredients.isEmpty() || this.method_10997().method_8608()) {
            return;
        }
        this.currentStew = world.method_64577().method_8132(PSRecipes.MASHING_TYPE, (class_9695)new MashingRecipe.Input(this.getPrimaryTank().getContents(), this.solidContents, this.suppliedIngredients), (class_1937)world).map(x$0 -> new Stew((class_8786<MashingRecipe>)x$0));
        if (this.currentStew.isEmpty() && this.suppliedIngredients.countMatches(stack -> !this.isValidIngredient(world, (class_1799)stack)) >= 8) {
            this.suppliedIngredients.clear();
            this.getPrimaryTank().setContents(PSFluids.SLURRY.getDefaultStack(this.getPrimaryTank().getContents().amount()));
            this.method_5431();
        }
    }

    public Stream<MashingRecipe> getPotentialMatches(class_3218 world) {
        MashingRecipe.Input input = new MashingRecipe.Input(this.getPrimaryTank().getContents(), this.solidContents, this.suppliedIngredients);
        return world.method_64577().getAllOfType(PSRecipes.MASHING_TYPE).stream().map(class_8786::comp_1933).filter(recipe -> recipe.matchesPartially(input, (class_1937)world));
    }

    private void spawnBubbles(int count, float spread, class_3414 sound) {
        class_5819 random = this.method_10997().method_8409();
        class_243 center = ParticleHelper.apply(this.method_11016().method_46558(), x -> random.method_43385(x, 0.25));
        Resovoir tank = this.getPrimaryTank();
        ParticleHelper.spawnParticles(this.method_10997(), (class_2394)new DrugDustParticleEffect(PSParticles.BUBBLE, tank.getContents().fluid().getColor(tank.getContents()), 1.0f), () -> ParticleHelper.apply(center, x -> random.method_43385(x, 0.5 + (double)spread)).method_1031(0.0, 0.5, 0.0), (Supplier<class_243>)Suppliers.ofInstance((Object)new class_243(random.method_43385(0.0, 0.125), random.method_43385(0.1, 0.125), random.method_43385(0.0, 0.125))), count);
        if (this.method_10997() instanceof class_3218) {
            this.method_10997().method_8396(null, this.method_11016(), sound, class_3419.field_15245, 0.5f + this.method_10997().method_8409().method_43057(), 0.3f + this.method_10997().method_8409().method_43057());
        } else {
            this.method_10997().method_45446(this.method_11016(), sound, class_3419.field_15245, 0.5f + this.method_10997().method_8409().method_43057(), 0.3f + this.method_10997().method_8409().method_43057(), true);
        }
    }

    @Override
    @Deprecated
    public List<class_1799> getDroppedStacks(class_1799 container) {
        ArrayList<class_1799> ingredients = new ArrayList<class_1799>((Collection<class_1799>)this.suppliedIngredients.convertToItemStacks());
        if (!this.solidContents.method_7960()) {
            ingredients.add(this.solidContents);
        }
        return ingredients;
    }

    @Override
    public Either<PipeInsertable.PipeFluids, class_3902> tryInsert(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction, PipeInsertable.PipeFluids fluids) {
        if (!this.currentStew.isEmpty()) {
            return PipeInsertable.reject(fluids);
        }
        return super.tryInsert(world, state, pos, direction, fluids);
    }

    @Override
    public Optional<PipeInsertable.PipeFluids> tryExtract(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction) {
        if (!this.currentStew.isEmpty()) {
            return Optional.empty();
        }
        return super.tryExtract(world, state, pos, direction);
    }

    @Override
    public void method_11007(class_2487 compound, class_7225.class_7874 lookup) {
        super.method_11007(compound, lookup);
        if (!this.solidContents.method_7960()) {
            compound.method_67494("solidContents", class_1799.field_49266, (Object)this.solidContents);
        }
        compound.method_10566("suppliedIngredients", (class_2520)this.suppliedIngredients.toNbt(lookup));
        compound.method_10566("auxiliaryFluids", this.auxiliaryFluids.encode());
    }

    @Override
    public void method_11014(class_2487 compound, class_7225.class_7874 lookup) {
        super.method_11014(compound, lookup);
        this.solidContents = compound.method_67491("solidContents", class_1799.field_49266).orElse(class_1799.field_8037);
        this.auxiliaryFluids = compound.method_67491("auxiliaryFluids", ItemFluids.CODEC).orElse(ItemFluids.EMPTY);
        this.suppliedIngredients.fromNbt(compound.method_68568("suppliedIngredients"), lookup);
    }

    class Stew
    implements NbtSerialisable {
        @Nullable
        private class_5321<class_1860<?>> recipe;
        private int stewTime;

        public Stew(class_8786<MashingRecipe> recipe) {
            this.recipe = recipe.comp_1932();
            this.stewTime = 2 + MashTubBlockEntity.this.field_11863.method_8409().method_43048(4) + ((MashingRecipe)recipe.comp_1933()).stewTime();
        }

        public boolean tick(class_3218 world) {
            if (this.recipe == null) {
                MashTubBlockEntity.this.method_5431();
                return false;
            }
            if (world.method_8510() % 30L == 0L) {
                MashTubBlockEntity.this.spawnBubbles(9, 0.5f, class_3417.field_19195);
                MashTubBlockEntity.this.method_5431();
                if (--this.stewTime <= 0) {
                    Object var3_2 = world.method_64577().method_8130(this.recipe).map(class_8786::comp_1933).orElse(null);
                    if (var3_2 instanceof MashingRecipe) {
                        MashingRecipe recipe = var3_2;
                        MashingRecipe.Input input = new MashingRecipe.Input(MashTubBlockEntity.this.getPrimaryTank().getContents(), MashTubBlockEntity.this.solidContents, MashTubBlockEntity.this.suppliedIngredients);
                        MashTubBlockEntity.this.getPrimaryTank().setContents(recipe.result().ofAmount(MashTubBlockEntity.this.getPrimaryTank().getContents().amount()));
                        recipe.getRemainder(input).forEach(stack -> class_2248.method_9577((class_1937)world, (class_2338)MashTubBlockEntity.this.method_11016(), (class_1799)stack));
                    }
                    MashTubBlockEntity.this.suppliedIngredients.clear();
                    return false;
                }
            }
            return true;
        }

        @Override
        public void toNbt(class_2487 compound, class_7225.class_7874 lookup) {
            compound.method_10569("stewTime", this.stewTime);
            compound.method_10582("recipe", this.recipe.toString());
        }

        @Override
        public void fromNbt(class_2487 compound, class_7225.class_7874 lookup) {
            this.stewTime = compound.method_68083("stewTime", 0);
            this.recipe = compound.method_67491("recipe", class_2960.field_25139).map(id -> class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)id)).orElse(null);
        }
    }
}

