/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block.entity;

import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.block.entity.SyncedBlockEntity;
import ivorius.psychedelicraft.client.render.bezier.Bezier;
import ivorius.psychedelicraft.entity.PSEntities;
import ivorius.psychedelicraft.entity.RealityRiftEntity;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_7225;

public class RiftJarBlockEntity
extends SyncedBlockEntity {
    public float currentRiftFraction;
    public int ticksAliveVisual;
    public boolean isOpening;
    public float fractionOpen;
    public boolean jarBroken = false;
    public boolean suckingRifts = true;
    public float fractionHandleUp;
    private final Map<UUID, JarRiftConnection> riftConnections = new HashMap<UUID, JarRiftConnection>();

    public RiftJarBlockEntity(class_2338 pos, class_2680 state) {
        super(PSBlockEntities.RIFT_JAR, pos, state);
    }

    public Collection<JarRiftConnection> getConnections() {
        return this.riftConnections.values();
    }

    public void tickAnimation() {
        this.fractionOpen = MathUtils.nearValue(this.fractionOpen, this.isOpening ? 1.0f : 0.0f, 0.0f, 0.02f);
        this.fractionHandleUp = MathUtils.nearValue(this.fractionHandleUp, this.isSuckingRifts() ? 0.0f : 1.0f, 0.0f, 0.04f);
        ++this.ticksAliveVisual;
    }

    public void tick(class_3218 world) {
        this.tickAnimation();
        if (this.isSuckingRifts()) {
            List<RealityRiftEntity> rifts;
            if (this.fractionOpen > 0.0f && (rifts = this.getAffectedRifts()).size() > 0) {
                float minus = 1.0f / (float)rifts.size() * 0.001f * this.fractionOpen;
                rifts.forEach(rift -> {
                    this.currentRiftFraction += rift.takeFromRift(minus);
                    JarRiftConnection connection = this.createAndGetRiftConnection((RealityRiftEntity)((Object)rift));
                    connection.fractionUp = Math.min(1.0f, connection.fractionUp + 0.02f * this.fractionOpen);
                });
            }
        } else if (this.fractionOpen > 0.0f) {
            float minus = Math.min(4.0E-4f * this.fractionOpen * this.currentRiftFraction + 4.0E-4f, this.currentRiftFraction);
            class_2338 pos = this.method_11016();
            class_243 center = pos.method_46558();
            world.method_8390(class_1309.class, new class_238((double)(pos.method_10263() - 5), (double)(pos.method_10264() - 5), (double)(pos.method_10260() - 2), (double)(pos.method_10263() + 6), (double)(pos.method_10264() + 6), (double)(pos.method_10260() + 6)), class_1301.field_6156).stream().flatMap(DrugProperties::stream).forEach(drugProperties -> {
                double effect = (5.0 - drugProperties.asEntity().method_19538().method_1022(center)) * (double)0.2f * (double)minus;
                drugProperties.addToDrug(DrugType.ZERO, effect * 5.0);
                drugProperties.addToDrug(DrugType.POWER, effect * 35.0);
            });
            this.currentRiftFraction -= minus;
        }
        this.riftConnections.values().removeIf(connection -> {
            float f;
            connection.fractionUp -= 0.01f;
            return f <= 0.0f;
        });
        if (this.currentRiftFraction > 1.0f) {
            this.jarBroken = true;
            this.releaseRift();
            world.method_22352(this.field_11867, false);
            class_243 explosionPosition = this.method_11016().method_46558();
            world.method_8537(null, explosionPosition.field_1352, explosionPosition.field_1351, explosionPosition.field_1350, 1.0f, false, class_1937.class_7867.field_40889);
        }
    }

    public JarRiftConnection createAndGetRiftConnection(RealityRiftEntity rift) {
        return this.riftConnections.computeIfAbsent(rift.method_5667(), id -> new JarRiftConnection(rift));
    }

    public boolean toggleRiftJarOpen() {
        if (this.field_11863 instanceof class_3218) {
            this.isOpening = !this.isOpening;
            this.method_5431();
        }
        return this.isOpening;
    }

    public void toggleSuckingRifts() {
        if (this.field_11863 instanceof class_3218) {
            this.suckingRifts = !this.suckingRifts;
            this.method_5431();
        }
    }

    public boolean isSuckingRifts() {
        return this.suckingRifts;
    }

    public void releaseRift() {
        if (this.currentRiftFraction > 0.0f) {
            List<RealityRiftEntity> rifts = this.getAffectedRifts();
            if (rifts.size() > 0) {
                rifts.get(0).addToRift(this.currentRiftFraction);
            } else if (!this.field_11863.field_9236) {
                RealityRiftEntity rift = (RealityRiftEntity)PSEntities.REALITY_RIFT.method_5883(this.field_11863, class_3730.field_16467);
                rift.method_33574(this.method_11016().method_46558().method_1031(5.0, 3.0, 0.5));
                rift.setRiftSize(this.currentRiftFraction);
                this.field_11863.method_8649((class_1297)rift);
            }
            this.currentRiftFraction = 0.0f;
        }
    }

    public List<RealityRiftEntity> getAffectedRifts() {
        class_2338 pos = this.method_11016();
        return this.field_11863.method_8390(RealityRiftEntity.class, new class_238((double)((float)pos.method_10263() - 2.0f), (double)((float)pos.method_10264() + 0.0f), (double)((float)pos.method_10260() - 2.0f), (double)((float)pos.method_10263() + 3.0f), (double)(pos.method_10264() + 10), (double)(pos.method_10260() + 3)), class_1301.field_6154);
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10548("currentRiftFraction", this.currentRiftFraction);
        compound.method_10556("isOpening", this.isOpening);
        compound.method_10548("fractionOpen", this.fractionOpen);
        compound.method_10556("jarBroken", this.jarBroken);
        compound.method_10556("suckingRifts", this.suckingRifts);
        compound.method_10548("fractionHandleUp", this.fractionHandleUp);
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 lookup) {
        this.currentRiftFraction = compound.method_66563("currentRiftFraction", 0.0f);
        this.isOpening = compound.method_68566("isOpening", false);
        this.fractionOpen = compound.method_66563("fractionOpen", 0.0f);
        this.jarBroken = compound.method_68566("jarBroken", false);
        this.suckingRifts = compound.method_68566("suckingRifts", false);
        this.fractionHandleUp = compound.method_66563("fractionHandleUp", 0.0f);
    }

    public static class JarRiftConnection {
        public final UUID riftID;
        public final class_243 position;
        public Bezier bezier;
        public float fractionUp;

        public JarRiftConnection(RealityRiftEntity rift) {
            this.riftID = rift.method_5667();
            this.position = rift.method_33571();
        }
    }
}

