/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client;

import com.google.common.base.Suppliers;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.PSClientConfig;
import ivorius.psychedelicraft.client.item.PSItemProperties;
import ivorius.psychedelicraft.client.render.DrugRenderer;
import ivorius.psychedelicraft.client.render.PSRenderers;
import ivorius.psychedelicraft.client.render.SmoothCameraHelper;
import ivorius.psychedelicraft.client.render.shader.ShaderLoader;
import ivorius.psychedelicraft.client.screen.PSScreens;
import ivorius.psychedelicraft.client.screen.SettingsScreen;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.ItemDrugs;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.ItemFluidsMixture;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_437;
import net.minecraft.class_9473;

public class PsychedelicraftClient
implements ClientModInitializer {
    private static final Supplier<PSClientConfig> CONFIG = Suppliers.memoize(() -> new PSClientConfig(FabricLoader.getInstance().getConfigDir().resolve("psychedelicraft_client.json")));

    public static PSClientConfig getConfig() {
        return CONFIG.get();
    }

    private void reInitScreen() {
        class_310 client = class_310.method_1551();
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof SettingsScreen) {
            SettingsScreen screen = (SettingsScreen)class_4372;
            screen.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4486());
        }
    }

    public void onInitializeClient() {
        try {
            PsychedelicraftClient.getConfig().load();
            PsychedelicraftClient.getConfig().onChangedExternally(cf -> this.reInitScreen());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Psychedelicraft.configChangeCallback = this::reInitScreen;
        Psychedelicraft.globalDrugProperties = () -> DrugProperties.of((class_1297)class_310.method_1551().field_1724);
        Psychedelicraft.crossHairTarget = () -> Optional.ofNullable(class_310.method_1551().field_1765);
        ClientTickEvents.START_CLIENT_TICK.register(client -> DrugProperties.of((class_1297)client.field_1724).ifPresent(properties -> {
            DrugRenderer.INSTANCE.update((DrugProperties)properties, (class_1309)client.field_1724);
            SmoothCameraHelper.INSTANCE.tick((DrugProperties)properties);
        }));
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            class_310 client = class_310.method_1551();
            DrugProperties.of((class_1297)client.field_1724).ifPresent(properties -> DrugRenderer.INSTANCE.renderAllHallucinations(context.matrixStack(), context.consumers(), context.camera(), context.tickCounter().method_60637(false), (DrugProperties)properties));
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)ShaderLoader.POST_EFFECTS);
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
            Processable.ProcessType.appendTooltip(stack, context, tooltip, type);
            if (FluidCapacity.get(stack) > 0) {
                Consumer<class_2561> consumer = tooltip::add;
                FluidCapacity.appendTooltip(stack, context, consumer, type);
                ItemFluids.of(stack).method_57409(context, consumer, type, (class_9473)stack);
                ItemFluidsMixture.of(stack).method_57409(context, consumer, type, (class_9473)stack);
            }
            ItemDrugs.get(stack).method_57409(context, tooltip::add, type, (class_9473)stack);
            Impurities.get(stack).method_57409(context, tooltip::add, type, (class_9473)stack);
            if (!lines.isEmpty()) {
                lines.addAll(1, tooltip);
            } else {
                lines.addAll(tooltip);
            }
        });
        PSRenderers.bootstrap();
        PSItemProperties.bootstrap();
        PSScreens.bootstrap();
    }
}

