/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.item.PlacementProperty;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7923;
import net.minecraft.class_811;

public class PlacedDrinksModelProvider
implements PreparableModelLoadingPlugin<Map<String, Map<class_2960, Entry>>>,
PreparableModelLoadingPlugin.DataLoader<Map<String, Map<class_2960, Entry>>> {
    private static final class_2960 CONFIG_LOCATION = Psychedelicraft.id("placeable_drinks.json");
    private static final Gson GSON = new Gson();
    public static final PlacedDrinksModelProvider INSTANCE = new PlacedDrinksModelProvider();
    private static final Codec<Map<String, Map<class_2960, Entry>>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, Entry.MAP_CODEC);
    private Map<String, Map<class_2960, Entry>> entries = Map.of();

    public CompletableFuture<Map<String, Map<class_2960, Entry>>> load(class_3300 resourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> resourceManager.method_14486(CONFIG_LOCATION).map(resource -> {
            Map map;
            block8: {
                BufferedReader reader = resource.method_43039();
                try {
                    map = (Map)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class))).getOrThrow()).getFirst();
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Psychedelicraft.LOGGER.error("Could not load client drinks file", (Throwable)e);
                        return null;
                    }
                }
                reader.close();
            }
            return map;
        }).orElseGet(Map::of), executor);
    }

    public void initialize(Map<String, Map<class_2960, Entry>> data, ModelLoadingPlugin.Context context) {
        this.entries = data;
    }

    public Optional<Entry> get(String type, class_1792 item) {
        return Optional.ofNullable(this.entries.get(type).get(class_7923.field_41178.method_10221((Object)item)));
    }

    public void renderDrink(String type, class_1799 stack, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        this.renderDrinkModel(type, stack, matrices, vertices, light, overlay);
        float fillPercentage = FluidCapacity.getPercentage(stack);
        Entry entry = this.get(type, stack.method_7909()).orElse(Entry.DEFAULT);
        if ((double)fillPercentage > 0.01 && entry.showFluid()) {
            float origin = entry.fluidOrigin() / 16.0f;
            matrices.method_46416(0.0f, origin, 0.0f);
            matrices.method_22905(1.0f, fillPercentage, 1.0f);
            matrices.method_46416(0.0f, -origin, 0.0f);
            this.renderDrinkModel(type + "_fluid", stack, matrices, vertices, light, overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderDrinkModel(String type, class_1799 stack, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        try {
            if (stack.method_31574(class_1802.field_8469)) {
                stack = stack.method_60503((class_1935)PSItems.FILLED_GLASS_BOTTLE);
            }
            matrices.method_22903();
            matrices.method_22904(0.5, 0.5, 0.5);
            PlacementProperty.setCurrent(type);
            class_310.method_1551().method_1480().method_23178(stack, class_811.field_4319, light, overlay, matrices, vertices, null, 0);
            matrices.method_22909();
        }
        finally {
            PlacementProperty.setCurrent(null);
        }
    }

    public record Entry(float height, float fluidOrigin, boolean showFluid) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("height").forGetter(Entry::height), (App)Codec.FLOAT.fieldOf("fluid_origin").forGetter(Entry::fluidOrigin), (App)Codec.BOOL.optionalFieldOf("show_fluid", (Object)false).forGetter(Entry::showFluid)).apply((Applicative)instance, Entry::new));
        public static final Codec<Map<class_2960, Entry>> MAP_CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, CODEC);
        public static final Entry DEFAULT = new Entry(0.5f, 0.0f, false);
    }
}

