/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render;

import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.render.RenderUtil;
import ivorius.psychedelicraft.client.render.ZeroScreen;
import ivorius.psychedelicraft.entity.RealityRiftEntity;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.Random;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class RealityRiftEntityRenderer
extends class_897<RealityRiftEntity, State> {
    public static final class_2960 CENTER_TEXTURE = Psychedelicraft.id("textures/entity/reality_rift/zero_center.png");
    private static final Random RANDOM = new Random(432L);

    public RealityRiftEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public State createRenderState() {
        return new State();
    }

    public void updateRenderState(RealityRiftEntity entity, State state, float tickDelta) {
        super.method_62354((class_1297)entity, (class_10017)state, tickDelta);
        float size = entity.getRiftSize(tickDelta);
        float instability = entity.getInstability();
        state.visualRiftSize = size < 0.01f ? size * 10.0f : 0.1f + 0.1f * (size - 0.01f);
        state.instability = state.field_53328 + tickDelta + instability * instability * 3000.0f;
    }

    protected class_238 getBoundingBox(RealityRiftEntity entity) {
        return entity.method_5829().method_1014(20.0);
    }

    public void render(State state, class_4587 matrices, class_4597 vertices, int light) {
        matrices.method_22903();
        matrices.method_22904(0.0, (double)state.field_53330 * 0.5, 0.0);
        matrices.method_22905(state.visualRiftSize, state.visualRiftSize, state.visualRiftSize);
        this.renderRift(matrices, vertices, state.instability);
        class_4588 consumer = vertices.getBuffer(class_1921.method_55252((class_2960)CENTER_TEXTURE));
        Vector4f vector = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        matrices.method_22903();
        matrices.method_22905(5.0f, 5.0f, 5.0f);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        float size = 1.0f;
        light = 0;
        Quaternionf cameraRotation = class_310.method_1551().field_1773.method_19418().method_23767();
        matrices.method_22907((Quaternionfc)cameraRotation);
        matrices.method_46416(-size * 0.5f, -size * 0.5f, 0.0f);
        vector.set(0.0f, 0.0f, 0.0f, 1.0f);
        Vector4f pos = positionMatrix.transform(vector);
        consumer.method_23919(pos.x, pos.y, pos.z, -1, 0.0f, 0.0f, light, 0, 1.0f, 1.0f, 1.0f);
        vector.set(size, 0.0f, 0.0f, 1.0f);
        pos = positionMatrix.transform(vector);
        consumer.method_23919(pos.x, pos.y, pos.z, -1, 1.0f, 0.0f, light, 0, 1.0f, 1.0f, 1.0f);
        vector.set(size, size, 0.0f, 1.0f);
        pos = positionMatrix.transform(vector);
        consumer.method_23919(pos.x, pos.y, pos.z, -1, 1.0f, 1.0f, light, 0, 1.0f, 1.0f, 1.0f);
        vector.set(0.0f, size, 0.0f, 1.0f);
        pos = positionMatrix.transform(vector);
        consumer.method_23919(pos.x, pos.y, pos.z, -1, 0.0f, 1.0f, light, 0, 1.0f, 1.0f, 1.0f);
        matrices.method_22909();
        matrices.method_22909();
    }

    public void renderRift(class_4587 matrices, class_4597 vertices, float age) {
        ZeroScreen.render(age, (layer, u, v) -> RealityRiftEntityRenderer.renderLightsScreen(matrices, vertices.getBuffer(layer), u, v, age, 1.0f, -1, 20));
    }

    public static void renderLightsScreen(class_4587 matrices, class_4588 vertices, float u, float v, float ticks, float alpha, int color, int number) {
        RANDOM.setSeed(432L);
        matrices.method_22903();
        float width = 2.5f;
        float rotation = ticks / 200.0f;
        int overlay = class_4608.field_21444;
        int light = 240;
        for (int i = 0; i < number; ++i) {
            float lightAlpha;
            float xLogFunc = ((float)i / (float)number * 28493.0f + ticks) / 10.0f % 20.0f;
            if (xLogFunc > 10.0f) {
                xLogFunc = 20.0f - xLogFunc;
            }
            if (!((lightAlpha = 1.0f / (1.0f + (float)Math.pow(2.71828f, -0.8f * xLogFunc) * 99.0f)) > 0.01f)) continue;
            matrices.method_22907((Quaternionfc)new Quaternionf().rotateXYZ(RANDOM.nextFloat() * ((float)Math.PI * 2), RANDOM.nextFloat() * ((float)Math.PI * 2), RANDOM.nextFloat() * ((float)Math.PI * 2)));
            matrices.method_22907((Quaternionfc)new Quaternionf().rotateXYZ(RANDOM.nextFloat() * ((float)Math.PI * 2), RANDOM.nextFloat() * ((float)Math.PI * 2), RANDOM.nextFloat() * ((float)Math.PI * 2) + rotation * 1.5707964f * 0.5f));
            float var8 = RANDOM.nextFloat() * 20.0f + 5.0f;
            float var9 = RANDOM.nextFloat() * 2.0f + 1.0f;
            int opaque = MathUtils.withAlpha(-1, alpha * lightAlpha);
            int transparent = MathUtils.withAlpha(-1, 0.0f);
            RenderUtil.vertex(vertices, matrices, 0.0f, 0.0f, 0.0f, opaque, 0.0f, 0.0f, light, overlay);
            RenderUtil.vertex(vertices, matrices, -width * var9, var8, -0.5f * var9, transparent, 0.0f, 0.0f, light, overlay);
            RenderUtil.vertex(vertices, matrices, width * var9, var8, -0.5f * var9, transparent, 0.0f, 0.0f, light, overlay);
            RenderUtil.vertex(vertices, matrices, 0.0f, var8, var9, transparent, 0.0f, 0.0f, light, overlay);
            RenderUtil.vertex(vertices, matrices, -width * var9, var8, -0.5f * var9, transparent, 0.0f, 0.0f, light, overlay);
        }
        matrices.method_22909();
    }

    static class State
    extends class_10017 {
        public float visualRiftSize;
        public float instability;

        State() {
        }
    }
}

