/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render;

import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_9848;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RenderUtil {
    private static final Vector4f POSITION_VECTOR = new Vector4f();
    private static final Vector3f NORMAL_VECTOR = new Vector3f();
    public static final int SCREEN_Z_OFFSET = -90;
    private static final Random RNG = new Random(0L);

    public static Random random(long seed) {
        RNG.setSeed(seed);
        return RNG;
    }

    public static class_4588 getBuffer(class_1921 layer) {
        return class_310.method_1551().method_22940().method_23000().getBuffer(layer);
    }

    public static void vertex(class_4588 buffer, class_4587 matrices, float x, float y, float z, float u, float v, int light, int overlay) {
        RenderUtil.vertex(buffer, matrices, x, y, z, -1, u, v, light, overlay);
    }

    public static void vertex(class_4588 buffer, class_4587 matrices, float x, float y, float z, int color, float u, float v, int light, int overlay) {
        matrices.method_23760().method_23761().transform(POSITION_VECTOR.set(x, y, z, 1.0f));
        matrices.method_23760().method_23762().transform(NORMAL_VECTOR.set(0.0f, -1.0f, 0.0f));
        buffer.method_23919(RenderUtil.POSITION_VECTOR.x, RenderUtil.POSITION_VECTOR.y, RenderUtil.POSITION_VECTOR.z, color, u, v, overlay, light, RenderUtil.NORMAL_VECTOR.x, RenderUtil.NORMAL_VECTOR.y, RenderUtil.NORMAL_VECTOR.z);
    }

    public static void drawQuad(class_332 context, class_2960 texture, float x0, float y0, float x1, float y1) {
        RenderUtil.drawQuad(context, texture, x0, y0, x1, y1, 0.0f);
    }

    private static void drawQuad(class_332 context, class_2960 texture, float x0, float y0, float x1, float y1, float z) {
        RenderUtil.drawQuad(context, class_1921.method_65216((class_2960)texture), x0, y0, x1, y1, z);
    }

    private static void drawQuad(class_332 context, class_1921 layer, float x0, float y0, float x1, float y1, float z) {
        class_4597.class_4598 vertices = class_310.method_1551().method_22940().method_23000();
        class_4588 buffer = vertices.getBuffer(layer);
        class_4587 matrices = context.method_51448();
        RenderUtil.vertex(buffer, matrices, x0, y1, z, -1, 0.0f, 1.0f, 0xF000F0, class_4608.field_21444);
        RenderUtil.vertex(buffer, matrices, x1, y1, z, -1, 1.0f, 1.0f, 0xF000F0, class_4608.field_21444);
        RenderUtil.vertex(buffer, matrices, x1, y0, z, -1, 1.0f, 0.0f, 0xF000F0, class_4608.field_21444);
        RenderUtil.vertex(buffer, matrices, x0, y0, z, -1, 0.0f, 0.0f, 0xF000F0, class_4608.field_21444);
        vertices.method_22993();
    }

    public static void drawOverlay(class_332 context, class_2960 texture, float alpha, int width, int height, float u0, float v0, float u1, float v1, int offset) {
        int color = class_9848.method_61330((int)class_9848.method_61326((float)alpha), (int)-1);
        RenderUtil.drawOverlay(context, texture, color, width, height, u0, v0, u1, v1, offset);
    }

    public static void drawOverlay(class_332 context, class_2960 texture, int color, int width, int height, float u0, float v0, float u1, float v1, int offset) {
        if (class_9848.method_61320((int)color) <= 0) {
            return;
        }
        class_4597.class_4598 vertices = class_310.method_1551().method_22940().method_23000();
        class_4588 buffer = vertices.getBuffer(class_1921.method_23580((class_2960)texture));
        class_4587 matrices = context.method_51448();
        RenderUtil.vertex(buffer, matrices, -offset, height + offset, -90.0f, color, u0, v1, 0xF000F0, class_4608.field_21444);
        RenderUtil.vertex(buffer, matrices, width + offset, height + offset, -90.0f, color, u1, v1, 0xF000F0, class_4608.field_21444);
        RenderUtil.vertex(buffer, matrices, width + offset, -offset, -90.0f, color, u1, v0, 0xF000F0, class_4608.field_21444);
        RenderUtil.vertex(buffer, matrices, -offset, -offset, -90.0f, color, u0, v0, 0xF000F0, class_4608.field_21444);
        vertices.method_22993();
    }

    public static void drawTexture(class_332 context, class_2960 texture, int width, int height, float r, float g, float b, float a) {
        int color = class_9848.method_61318((float)a, (float)r, (float)g, (float)b);
        class_4597.class_4598 vertices = class_310.method_1551().method_22940().method_23000();
        class_1921 layer = class_1921.method_62275((class_2960)texture);
        class_4588 buffer = vertices.getBuffer(layer);
        class_4587 matrices = context.method_51448();
        float scaleFactor = (float)class_310.method_1551().method_22683().method_4495();
        RenderUtil.vertex(buffer, matrices, 0.0f, (float)height / scaleFactor, 0.0f, color, 0.0f, 0.0f, 0xF000F0, class_4608.field_21444);
        RenderUtil.vertex(buffer, matrices, (float)width / scaleFactor, (float)height / scaleFactor, 0.0f, color, 1.0f, 0.0f, 0xF000F0, class_4608.field_21444);
        RenderUtil.vertex(buffer, matrices, (float)width / scaleFactor, 0.0f, 0.0f, color, 1.0f, 1.0f, 0xF000F0, class_4608.field_21444);
        RenderUtil.vertex(buffer, matrices, 0.0f, 0.0f, 0.0f, color, 0.0f, 1.0f, 0xF000F0, class_4608.field_21444);
        vertices.method_22993();
    }

    public static void drawRepeatingSprite(class_332 context, class_1058 sprite, int x, int y, int width, int height, int color) {
        int tileSize = 16;
        int tilesX = width / 16;
        int tilesY = height / 16;
        int remainedWidth = width % 16;
        int remainedHeight = height % 16;
        for (int tileX = 0; tileX <= tilesX; ++tileX) {
            for (int tileY = 0; tileY <= tilesY; ++tileY) {
                int h;
                int w = tileX == tilesX ? remainedWidth : 16;
                int n = h = tileY == tilesY ? remainedHeight : 16;
                if (h <= 0 || w <= 0) continue;
                context.method_52710(class_1921::method_62275, sprite, x + tileX * 16, y + tileY * 16, w, h, color);
            }
        }
    }
}

