/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.blocks;

import ivorius.psychedelicraft.block.entity.BurnerBlockEntity;
import ivorius.psychedelicraft.block.entity.contents.LargeContents;
import ivorius.psychedelicraft.block.entity.contents.SmallContents;
import ivorius.psychedelicraft.client.render.FluidBoxRenderer;
import ivorius.psychedelicraft.client.render.PlacedDrinksModelProvider;
import ivorius.psychedelicraft.client.render.blocks.LabelledBlockEntityRenderer;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9848;
import org.joml.Quaternionfc;

public class BurnerBlockEntityRenderer
extends LabelledBlockEntityRenderer<BurnerBlockEntity> {
    private final class_918 itemRenderer;

    public BurnerBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
        this.itemRenderer = context.method_43335();
    }

    public void render(BurnerBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertices, int light, int overlay, class_243 cameraPos) {
        BurnerBlockEntity.Contents contents = entity.getContents();
        if (contents instanceof Processable.Context) {
            Processable.Context contents2 = (Processable.Context)((Object)contents);
            if (!entity.getContainer().method_7960()) {
                matrices.method_22903();
                if (entity.getTemperature() >= 99) {
                    float ticks = (float)class_310.method_1551().field_1724.field_6012 + tickDelta;
                    float amplitude = 5.0f;
                    matrices.method_22904(0.5, 0.0, 0.5);
                    matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)ticks) * amplitude));
                    matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(class_3532.method_15374((float)(ticks + 9.0f + class_3532.method_15374((float)ticks))) * amplitude));
                    matrices.method_22904(-0.5, 0.0, -0.5);
                }
                matrices.method_22904(0.0, 0.12, 0.0);
                PlacedDrinksModelProvider.INSTANCE.renderDrink("burner", ItemFluids.getItemForFluids(entity.getContainer(), ItemFluids.EMPTY), matrices, vertices, light, overlay);
                if (contents2 instanceof LargeContents) {
                    LargeContents largeContents = (LargeContents)contents2;
                    BurnerBlockEntityRenderer.renderFlaskMultiFluids(largeContents, matrices, vertices, light, overlay);
                    this.renderIngredients(entity, largeContents, matrices, vertices, light, overlay);
                }
                if (contents2 instanceof SmallContents) {
                    SmallContents smallContents = (SmallContents)contents2;
                    BurnerBlockEntityRenderer.renderFlaskSingleFluid(smallContents, matrices, vertices, light, overlay);
                }
                matrices.method_22909();
            }
        }
        super.method_3569(entity, tickDelta, matrices, vertices, light, overlay, cameraPos);
    }

    @Override
    protected float getLabelScale(BurnerBlockEntity entity, float tickDelta) {
        if (entity.getTemperature() > 100) {
            return super.getLabelScale(entity, tickDelta) + tickDelta * 0.001f;
        }
        return super.getLabelScale(entity, tickDelta);
    }

    @Override
    protected void renderLabels(BurnerBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        int temperature = entity.getTemperature();
        String text = "" + temperature;
        int width = this.textRenderer.method_1727(text);
        int temperatureColorComponent = class_3532.method_15340((int)((int)(255.0f * (1.0f - (float)temperature / 100.0f))), (int)0, (int)255);
        int temperatureColor = class_9848.method_61324((int)255, (int)255, (int)temperatureColorComponent, (int)temperatureColorComponent);
        this.textRenderer.method_27521(text, (float)(-width) / 2.0f, 0.0f, temperatureColor, true, matrices.method_23760().method_23761(), vertices, class_327.class_6415.field_33993, 0, light);
        matrices.method_22905(0.9f, 0.9f, 0.9f);
        float f = (float)width / 4.0f;
        Objects.requireNonNull(this.textRenderer);
        this.textRenderer.method_27521(" o", f, (float)(-9) / 2.0f, temperatureColor, true, matrices.method_23760().method_23761(), vertices, class_327.class_6415.field_33993, 0, light);
        int maxCapacity = FluidCapacity.get(entity.getContainer());
        if (maxCapacity > 0) {
            class_2561 fillText = BurnerBlockEntityRenderer.getFillPercentage(entity, maxCapacity);
            float f2 = (float)(-(this.textRenderer.method_27525((class_5348)fillText) - 5)) / 2.0f;
            Objects.requireNonNull(this.textRenderer);
            this.textRenderer.method_27522(fillText, f2, (float)(-9 - 2), -1, true, matrices.method_23760().method_23761(), vertices, class_327.class_6415.field_33993, 0, light);
        }
    }

    static void renderFlaskSingleFluid(SmallContents contents, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        matrices.method_22903();
        matrices.method_22905(0.0625f, 0.0625f, 0.0625f);
        Resovoir tank = contents.getPrimaryTank();
        float fluidHeight = 2.4f * ((float)tank.getContents().amount() / (float)tank.getCapacity());
        FluidBoxRenderer.getInstance().light(light).overlay(overlay).position(matrices).texture(vertices, tank.getContents()).draw(6.7f, 0.5f, 6.7f, 2.6f, fluidHeight, 2.6f, class_2350.field_11033, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039);
        matrices.method_22909();
    }

    static void renderFlaskMultiFluids(LargeContents contents, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        matrices.method_22903();
        matrices.method_22905(0.0625f, 0.0625f, 0.0625f);
        FluidBoxRenderer renderer = FluidBoxRenderer.getInstance().light(light).overlay(overlay).position(matrices);
        float fluidStartY = 0.0f;
        List<Resovoir> tanks = contents.getAuxiliaryTanks();
        for (Resovoir tank : tanks) {
            float maxY;
            float minY;
            renderer.texture(vertices, tank.getContents());
            float fluidHeight = 6.0f * ((float)tank.getContents().amount() / (float)tank.getCapacity());
            float fluidEndY = fluidStartY + fluidHeight;
            if (fluidStartY < 1.0f && fluidEndY > 0.0f) {
                if (fluidStartY <= 0.0f) {
                    renderer.draw(5.0f, 1.0f, 5.0f, 6.0f, 1.0f, 6.0f, class_2350.field_11033);
                }
                float maxY2 = Math.min(1.0f, fluidEndY);
                renderer.draw(5.0f, 1.0f, 5.0f, 6.0f, maxY2, 6.0f, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039);
                if (fluidEndY <= 1.0f) {
                    renderer.draw(5.0f, 1.0f, 5.0f, 6.0f, maxY2, 6.0f, class_2350.field_11036);
                }
            }
            if (fluidStartY < 2.0f && fluidEndY > 1.0f) {
                if (fluidStartY <= 1.0f) {
                    renderer.draw(4.0f, 2.0f, 6.0f, 1.0f, 1.0f, 4.0f, class_2350.field_11033);
                    renderer.draw(11.0f, 2.0f, 6.0f, 1.0f, 1.0f, 4.0f, class_2350.field_11033);
                    renderer.draw(6.0f, 2.0f, 4.0f, 4.0f, 1.0f, 1.0f, class_2350.field_11033);
                    renderer.draw(6.0f, 2.0f, 11.0f, 4.0f, 1.0f, 1.0f, class_2350.field_11033);
                }
                minY = Math.max(fluidStartY, 1.0f) + 1.0f;
                maxY = Math.min(1.0f, fluidEndY - 1.0f) - minY + 2.0f;
                renderer.draw(5.0f, minY, 5.0f, 1.0f, maxY, 1.0f, class_2350.field_11039, class_2350.field_11043);
                renderer.draw(5.0f, minY, 10.0f, 1.0f, maxY, 1.0f, class_2350.field_11039, class_2350.field_11035);
                renderer.draw(10.0f, minY, 5.0f, 1.0f, maxY, 1.0f, class_2350.field_11034, class_2350.field_11043);
                renderer.draw(10.0f, minY, 10.0f, 1.0f, maxY, 1.0f, class_2350.field_11034, class_2350.field_11035);
                renderer.draw(4.0f, minY, 6.0f, 1.0f, maxY, 4.0f, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035);
                renderer.draw(11.0f, minY, 6.0f, 1.0f, maxY, 4.0f, class_2350.field_11034, class_2350.field_11043, class_2350.field_11035);
                renderer.draw(6.0f, minY, 4.0f, 4.0f, maxY, 1.0f, class_2350.field_11043, class_2350.field_11034, class_2350.field_11039);
                renderer.draw(6.0f, minY, 11.0f, 4.0f, maxY, 1.0f, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039);
                if (fluidEndY <= 2.0f) {
                    renderer.draw(5.0f, 2.0f, 5.0f, 6.0f, maxY, 6.0f, class_2350.field_11036);
                    renderer.draw(4.0f, 2.0f, 6.0f, 1.0f, maxY, 4.0f, class_2350.field_11036);
                    renderer.draw(11.0f, 2.0f, 6.0f, 1.0f, maxY, 4.0f, class_2350.field_11036);
                    renderer.draw(6.0f, 2.0f, 4.0f, 4.0f, maxY, 1.0f, class_2350.field_11036);
                    renderer.draw(6.0f, 2.0f, 11.0f, 4.0f, maxY, 1.0f, class_2350.field_11036);
                }
            }
            if (fluidStartY <= 3.0f && fluidEndY > 2.0f) {
                if (fluidStartY <= 2.0f) {
                    renderer.draw(4.0f, 3.0f, 5.0f, 1.0f, 1.0f, 1.0f, class_2350.field_11033);
                    renderer.draw(4.0f, 3.0f, 10.0f, 1.0f, 1.0f, 1.0f, class_2350.field_11033);
                    renderer.draw(11.0f, 3.0f, 5.0f, 1.0f, 1.0f, 1.0f, class_2350.field_11033);
                    renderer.draw(11.0f, 3.0f, 10.0f, 1.0f, 1.0f, 1.0f, class_2350.field_11033);
                    renderer.draw(5.0f, 3.0f, 4.0f, 1.0f, 1.0f, 1.0f, class_2350.field_11033);
                    renderer.draw(10.0f, 3.0f, 4.0f, 1.0f, 1.0f, 1.0f, class_2350.field_11033);
                    renderer.draw(5.0f, 3.0f, 11.0f, 1.0f, 1.0f, 1.0f, class_2350.field_11033);
                    renderer.draw(10.0f, 3.0f, 11.0f, 1.0f, 1.0f, 1.0f, class_2350.field_11033);
                }
                minY = Math.max(fluidStartY, 2.0f) + 1.0f;
                maxY = Math.min(4.0f, fluidEndY - 2.0f) - minY + 3.0f;
                renderer.draw(4.0f, minY, 5.0f, 1.0f, maxY, 6.0f, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035);
                renderer.draw(11.0f, minY, 5.0f, 1.0f, maxY, 6.0f, class_2350.field_11034, class_2350.field_11043, class_2350.field_11035);
                renderer.draw(5.0f, minY, 4.0f, 6.0f, maxY, 1.0f, class_2350.field_11043, class_2350.field_11034, class_2350.field_11039);
                renderer.draw(5.0f, minY, 11.0f, 6.0f, maxY, 1.0f, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039);
                renderer.draw(4.0f, minY, 5.0f, 1.0f, maxY, 6.0f, class_2350.field_11036);
                renderer.draw(11.0f, minY, 5.0f, 1.0f, maxY, 6.0f, class_2350.field_11036);
                renderer.draw(5.0f, minY, 4.0f, 6.0f, maxY, 8.0f, class_2350.field_11036);
            }
            fluidStartY = fluidEndY;
        }
        matrices.method_22909();
    }

    private void renderIngredients(BurnerBlockEntity entity, LargeContents contents, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        float itemScale = 0.35f;
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
        matrices.method_22905(itemScale, itemScale, itemScale);
        class_5819 rng = class_5819.method_43049((long)entity.method_11016().method_10063());
        float y = 0.0f;
        for (int i = 0; i < contents.getIngredients().size(); ++i) {
            class_1799 stack = contents.getIngredients().getStack(i);
            for (int j = 0; j < stack.method_7947(); ++j) {
                matrices.method_22903();
                matrices.method_22904((double)((rng.method_43057() - 0.5f) * 0.5f), (double)((rng.method_43057() - 0.5f) * 0.8f), -0.05 + (double)y);
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(rng.method_43057() * 360.0f - 180.0f));
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(rng.method_43057() * 360.0f - 180.0f));
                y -= 0.1f;
                this.itemRenderer.method_23178(stack, class_811.field_4319, light, overlay, matrices, vertices, entity.method_10997(), 0);
                matrices.method_22909();
            }
        }
        matrices.method_22909();
    }
}

