/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.blocks;

import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.block.entity.FluidFilled;
import ivorius.psychedelicraft.block.entity.MashTubBlockEntity;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.client.render.BlockBreakingProgressAccessor;
import ivorius.psychedelicraft.client.render.FluidBoxRenderer;
import ivorius.psychedelicraft.client.render.blocks.LabelledBlockEntityRenderer;
import ivorius.psychedelicraft.client.render.shader.ShaderContext;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.Objects;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_9974;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class MashTubBlockEntityRenderer
extends LabelledBlockEntityRenderer<MashTubBlockEntity> {
    private static final MashTubBlockEntity ITEM_ENTITY = (MashTubBlockEntity)PSBlockEntities.MASH_TUB.method_11032(class_2338.field_10980, PSBlocks.MASH_TUB.method_9564());

    public MashTubBlockEntityRenderer(class_5614.class_5615 context) {
        super(context.method_32143());
    }

    public MashTubBlockEntityRenderer() {
        super(class_310.method_1551().field_1772);
    }

    public void renderAsItem(ItemFluids fluids, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        ITEM_ENTITY.getPrimaryTank().setContents(fluids);
        class_2680 state = ITEM_ENTITY.method_11010();
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        class_778.method_3367((class_4587.class_4665)matrices.method_23760(), (class_4588)vertices.getBuffer(class_4696.method_23679((class_2680)state)), (class_1087)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)light, (int)overlay);
        class_778.method_3367((class_4587.class_4665)matrices.method_23760(), (class_4588)vertices.getBuffer(class_4696.method_23683((class_2680)state)), (class_1087)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)light, (int)overlay);
        if (!fluids.isEmpty()) {
            float fillPercentage = class_3532.method_15363((float)((float)fluids.amount() / 729000.0f), (float)0.0f, (float)2.0f);
            float fluidHeight = 0.1f;
            fluidHeight = 0.3f + fillPercentage * 0.6f;
            FluidBoxRenderer.getInstance().scale(1.0f).light(light).overlay(overlay).position(matrices).texture(vertices, fluids).draw(-0.5f, 0.0f, -0.5f, 2.0f, fluidHeight, 2.0f, class_2350.field_11036);
        }
    }

    public void render(MashTubBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertices, int light, int overlay, class_243 cameraPos) {
        class_1799 s;
        float fillPercentage;
        int damageStage = MashTubBlockEntityRenderer.getDamageStage(entity.method_10997(), entity.method_11016());
        if (damageStage != 0) {
            class_2680 state = entity.method_11010();
            class_1087 model = class_310.method_1551().method_1541().method_3349(state);
            class_4583 consumer = new class_4583(vertices.getBuffer((class_1921)class_1088.field_21772.get(damageStage)), matrices.method_23760(), 1.0f);
            class_778.method_3367((class_4587.class_4665)matrices.method_23760(), (class_4588)consumer, (class_1087)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)light, (int)overlay);
        }
        Resovoir tank = entity.getPrimaryTank();
        ItemFluids stack = tank.getContents();
        float fluidHeight = 0.3f;
        FluidBoxRenderer.getInstance().scale(1.0f).light(light).overlay(overlay).position(matrices);
        if (!stack.isEmpty()) {
            fillPercentage = class_3532.method_15363((float)((float)stack.amount() / (float)tank.getCapacity()), (float)0.0f, (float)2.0f);
            FluidBoxRenderer.getInstance().texture(vertices, stack).draw(-0.5f, 0.0f, -0.5f, 2.0f, fluidHeight += fillPercentage * 0.6f, 2.0f, class_2350.field_11036);
        }
        if (!(stack = entity.getAuxiliaryFluids()).isEmpty()) {
            fillPercentage = class_3532.method_15363((float)((float)stack.amount() / (float)tank.getCapacity()), (float)0.0f, (float)2.0f);
            FluidBoxRenderer.getInstance().texture(vertices, stack).draw(-0.5f, 0.0f, -0.5f, 2.0f, fluidHeight += fillPercentage * 0.6f, 2.0f, class_2350.field_11036);
        }
        if (!entity.solidContents.method_7960() && entity.solidContents.method_7909() instanceof class_1747) {
            FluidBoxRenderer.getInstance().texture(vertices, entity.solidContents).draw(-0.3f, 0.0f, -0.3f, 1.6f, 0.2f, 1.6f, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039).draw(-0.2f, 0.0f, -0.2f, 1.4f, 0.3f, 1.4f, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039);
        }
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.75f, 0.0f);
        long seed = entity.method_11016().method_10063() + 1L;
        class_5819 random = class_5819.method_43047();
        random.method_43052(seed);
        for (int i = 0; i < entity.getSuppliedIngredients().size(); ++i) {
            s = entity.getSuppliedIngredients().getStack(i);
            for (int c = 0; c < s.method_7947(); ++c) {
                float positionX = 0.5f + (random.method_43057() - 0.5f) * 1.5f;
                float positionZ = 0.5f + (random.method_43057() - 0.5f) * 1.5f;
                float rotation = random.method_43057() * 360.0f;
                matrices.method_22903();
                matrices.method_46416(positionX, fluidHeight / 16.0f - 0.02f, positionZ);
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(rotation));
                matrices.method_22905(0.3f, 0.3f, 0.3f);
                int singleDifference = c * 5;
                float bob = class_3532.method_15374((float)((ShaderContext.ticks() + (float)singleDifference) / 8.0f)) * 0.2f;
                float spin = class_3532.method_15362((float)((ShaderContext.ticks() + (float)singleDifference) / 8.0f)) * 0.12f;
                matrices.method_46416(0.0f, bob, -0.2f);
                matrices.method_22907((Quaternionfc)class_7833.field_40717.rotationDegrees(-50.0f * spin));
                matrices.method_22907((Quaternionfc)class_7833.field_40715.rotationDegrees((ShaderContext.ticks() + (float)c) % 360.0f));
                class_310.method_1551().method_1480().method_23178(s, class_811.field_4319, light, overlay, matrices, vertices, entity.method_10997(), (int)seed);
                matrices.method_22909();
            }
        }
        matrices.method_22909();
        super.method_3569(entity, tickDelta, matrices, vertices, light, overlay, cameraPos);
        if (class_310.method_1551().method_1561().method_3958() && !class_310.method_1551().method_1555() && entity.method_10997() != null && entity.method_11016() != null && (s = entity.method_11010().method_26204()) instanceof FluidFilled) {
            FluidFilled tub = (FluidFilled)s;
            class_238 box = new class_238(0.0, 0.0, 0.0, 1.0, tub.getFluidHeight(entity.method_10997(), entity.method_11010(), entity.method_11016()), 1.0).method_1014(0.001);
            matrices.method_22903();
            class_9974.method_62295((class_4587)matrices, (class_4588)vertices.getBuffer(class_1921.method_23594()), (class_238)box, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
            box = tub.getFluidCollisionBox(entity.method_10997(), entity.method_11010(), entity.method_11016());
            matrices.method_22904(-box.field_1323 - (box.method_17939() - 1.0) / 2.0, -box.field_1322, -box.field_1321 - (box.method_17941() - 1.0) / 2.0);
            class_9974.method_62295((class_4587)matrices, (class_4588)vertices.getBuffer(class_1921.method_23594()), (class_238)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.method_22909();
        }
    }

    @Override
    protected double getLabelDistanceFromCenter(MashTubBlockEntity entity) {
        return 1.8;
    }

    @Override
    protected void renderLabels(MashTubBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        Processable.ProcessType processType = entity.getActiveProcess();
        class_2561 process = entity.getActiveProcess().getStatus();
        if (processType != Processable.ProcessType.IDLE) {
            int progress = (int)(entity.getProgress(tickDelta) * 100.0f);
            process = process.method_27661().method_27693("... " + progress + "%");
        }
        this.textRenderer.method_27522(process, (float)(-(this.textRenderer.method_27525((class_5348)process) - 5)) / 2.0f, 0.0f, -1, true, matrices.method_23760().method_23761(), vertices, class_327.class_6415.field_33993, 0, light);
        matrices.method_22905(0.9f, 0.9f, 0.9f);
        class_2561 fill = MashTubBlockEntityRenderer.getFillPercentage(entity, 729000);
        float f = (float)(-(this.textRenderer.method_27525((class_5348)fill) - 5)) / 2.0f;
        Objects.requireNonNull(this.textRenderer);
        this.textRenderer.method_27522(fill, f, (float)(-9 - 2), -1, true, matrices.method_23760().method_23761(), vertices, class_327.class_6415.field_33993, 0, light);
    }

    static int getDamageStage(@Nullable class_1937 world, @Nullable class_2338 center) {
        if (world == null || center == null || BlockBreakingProgressAccessor.getStage(center) != 0) {
            return 0;
        }
        int stage = 0;
        for (class_2338 pos : class_2338.method_30512((class_2338)center, (int)1, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
            if (!world.method_8320(pos).method_27852(PSBlocks.MASH_TUB_EDGE)) continue;
            stage = Math.max(stage, BlockBreakingProgressAccessor.getStage(pos));
        }
        return stage;
    }
}

